<?php

namespace Wi\Admin\CoreBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class DropTableMenuCommand extends ContainerAwareCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('app:doctrine:core:drop-table-menu')
            ->setDescription('Usun tabele dla Menu')
            ->setHelp('Usun tabele dla Menu')
        ;
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get('doctrine.orm.entity_manager');
        $conn = $em->getConnection();
        $menuTable = $em->getClassMetadata('WiAdminCoreBundle:Menu')->getTableName();

        $sql = "DROP TABLE IF EXISTS $menuTable";
        $stmt = $conn->prepare($sql);
        $res = $stmt->execute();

        if ($res) {
            $output->writeln('Usunieto tabele: <info>' . $menuTable . '</info>');
        }
    }
}
