<?php

namespace Wi\Admin\ContactBundle\Service;

use Wi\Admin\ContactBundle\Entity\Answer;
use Wi\Admin\ContactBundle\Entity\Form;
use Wi\Admin\CoreBundle\Service\Mailer as BaseMailer;

class Mailer extends BaseMailer
{
    /**
     * Wysłanie wiadomości z formularza kontaktowego.
     *
     * @param Answer $answer
     * @return int
     */
    public function sendContactFormMessage(Answer $answer)
    {
        $recipients = $this->prepareRecipients($answer->getForm()->getRecipients());

        if (empty($recipients)) {
            return false;
        }

        $this->message
            ->setTo($recipients)
            ->setSubject($answer->getForm()->getName())
            ->setBody(
                $this->render('WiAdminContactBundle:templates:emails/contact_form_message.html.twig', [
                    'answer' => $answer,
                ]),
                'text/html'
            )
        ;

        return $this->send();
    }

    public function sendAutoreply(Form $form, $email)
    {
        $this->message
            ->setTo($email)
            ->setSubject($form->getReplySubject())
            ->setBody(
                $this->render('WiAdminContactBundle:templates:emails/contact_form__autoreply_message.html.twig', [
                    'form' => $form,
                ]),
                'text/html'
            )
        ;

        return $this->send();
    }

    private function prepareRecipients($recipients)
    {
        if (empty($recipients)) {
            return false;
        }

        $out = [];
        $emails = array_map('trim', explode(';', $recipients));

        foreach ($emails as $email) {
            if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $out[] = $email;
            }
        }

        return $out;
    }
}
