<?php $view->extend('::wicms.html.php') ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_contact_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.contact.edit')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/contact.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_contact_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.contact.index'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_contact_edit', ['id' => $Form->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.contact.edit'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-post"></i><?php echo $view['translator']->trans('contact.title'); ?> - <?php echo $view['translator']->trans('contact.titleEdit'); ?> - <?php echo $Form->getName(); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('contact.descEdit'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery.collection.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>" type="text/javascript"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/contact.js') ?>" type="text/javascript"></script>
    <script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo $GoogleapiKey; ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('menuShowSite'); ?>
<div class="menu-show-site">
    <a  class="button warning tiny" href="<?php echo $view['router']->path('wi_front_contact_index_2', ['id' => $Form->getId(), 'slug' => $view['front']->slugify($Form->getName())]); ?>" title="<?php echo $view['translator']->trans('top-bar.showArticle'); ?>" target="_blank">
        <i class="icon-monitor-1"></i>
        <span>
            <?php echo $view['translator']->trans('top-bar.showArticle'); ?>
        </span>
    </a>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<?php echo $view['form']->start($form, ['attr' => ['class' => 'formEditForm']]); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-mail"></i>
            <span><?php echo $view['translator']->trans('contactEdit.titleBasic'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns medium-6">
                <?php echo $view['form']->label($form['name']); ?>
                <?php if ($view['form']->errors($form['name'])): ?>
                    <div class="callout small alert">
                        <?php echo $view['form']->errors($form['name']); ?>
                    </div>
                <?php endif; ?>
                <?php echo $view['form']->widget($form['name']); ?>
            </div>
            <div class="columns medium-6">
                <?php echo $view['form']->label($form['type']); ?>
                <?php if ($view['form']->errors($form['type'])): ?>
                    <div class="callout small alert">
                        <?php echo $view['form']->errors($form['type']); ?>
                    </div>
                <?php endif; ?>
                <?php echo $view['form']->widget($form['type']); ?>
            </div>
        </div>
    </div>
</div>
<?php if($Form->getType() == 'C'): ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-doc-text"></i>
                <span><?php echo $view['translator']->trans('contactEdit.titleArticle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="columns small-10 medium-6">
                    <?php echo $view['form']->label($form['page']); ?>
                    <?php if ($view['form']->errors($form['page'])): ?>
                        <div class="callout small alert">
                            <?php echo $view['form']->errors($form['page']); ?>
                        </div>
                    <?php endif; ?>
                    <?php echo $view['form']->widget($form['page'],['disabled' => true]); ?>
                </div>
                <div class="columns small-2 medium-6 end">
                    <a class="editPage"><?php echo $view['translator']->trans('contactEdit.changePage'); ?></a>
                    <?php echo $view['form']->widget($form['save']); ?>
                </div>
            </div>
            <div class="row pageInline">
                <?php if ($Form->getPage()): ?>
                    <div class="columns">
                        <?php echo $view['form']->label($form['pageTitle']); ?>
                        <?php if ($view['form']->errors($form['pageTitle'])): ?>
                            <div class="callout small alert">
                                <?php echo $view['form']->errors($form['pageTitle']); ?>
                            </div>
                        <?php endif; ?>
                        <?php echo $view['form']->widget($form['pageTitle']); ?>
                    </div>
                    <div class="columns">
                        <?php echo $view['form']->label($form['pageContent']); ?>
                        <?php if ($view['form']->errors($form['pageContent'])): ?>
                            <div class="callout small alert">
                                <?php echo $view['form']->errors($form['pageContent']); ?>
                            </div>
                        <?php endif; ?>
                        <?php echo $view['form']->widget($form['pageContent']); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php if($Form->getType() == 'C'): ?>
    <div class="box interactiveMaps">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-location"></i>
                <span><?php echo $view['translator']->trans('contactEdit.titleMaps'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php foreach ($form['maps'] as $key=>$map): ?>
                <div class="row">
                    <div class="columns">
                        <label for="urlGoogleMaps"><?php echo $view['translator']->trans('contactEdit.mapsLabelUrl'); ?>:</label>
                        <?php echo $view['form']->widget($map['embeded'], ['attr' => ['readonly' => ($map->vars['value']->getCustomMap())]]) ?>
                        <p class="switchLabel"><?php echo $view['translator']->trans('contactEdit.mapsLabelSwitch'); ?>:</p>
                        <div class="switch">
                            <?php echo $view['form']->widget($map['customMap']) ?>
                            <label class="switch-paddle" for="<?php echo $map->children['customMap']->vars['id']; ?>">
                                <span class="show-for-sr"><?php echo $view['translator']->trans('contactEdit.mapsLabelSwitch'); ?></span>
                                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                            </label>
                        </div>

                    </div>
                </div>
                <div class="row mapsGenerator <?php echo $map->vars['value']->getCustomMap() ? '' : 'hide'; ?>">
                    <div class="columns small-12 medium-6 windowPinBox">
                        <label><?php echo $view['translator']->trans('contactEdit.textareaPinWindow'); ?>:</label>
                        <?php echo $view['form']->row($map['windowInfo']) ?>
                    </div>
                    <div class="columns small-12 medium-6">
                        <div class="googlemaps text-center responsive-embed" id="googleMaps" data-lat="<?php echo $map->children['lat']->vars['value'] ? $map->children['lat']->vars['value'] : '50'; ?>" data-lng="<?php echo $map->children['lng']->vars['value'] ? $map->children['lng']->vars['value'] : '21'; ?>" data-zoom="<?php echo $map->children['lat']->vars['value'] ? $map->children['zoom']->vars['value'] : '11'; ?>">
                            <h3><?php echo $view['translator']->trans('contactEdit.googleMapsInfo'); ?></h3>
                        </div>
                    </div>
                </div>
                <div class="row mapsEmbed <?php echo $map->vars['value']->getCustomMap() ? 'hide' : ''; ?>">
                    <div class="columns">
                        <div class="googlemapsembed float-center">
                            <?php echo $map->children['embeded']->vars['value']; ?>
                        </div>
                        <?php if(is_null($GoogleapiKey) || empty($GoogleapiKey)): ?>
                            <span><?php echo $view['translator']->trans('contactEdit.notApiKey'); ?></span> <a
                                    href="<?php echo $view['router']->path('wi_admin_core_config_contact'); ?>"><?php echo $view['translator']->trans('contactEdit.configContact'); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php echo $view['form']->row($map['lat']) ?>
                <?php echo $view['form']->row($map['lng']) ?>
                <?php echo $view['form']->row($map['zoom']) ?>
                <?php echo $view['form']->row($map['orderNr']) ?>
                <?php echo $view['form']->row($map['pin']) ?>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-doc-text-inv-1"></i>
            <span><?php echo $view['translator']->trans('contactEdit.formTitle'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns">
                <?php echo $view['form']->label($form['recipients']); ?>
                <?php if ($view['form']->errors($form['recipients'])): ?>
                    <div class="callout small alert">
                        <?php echo $view['form']->errors($form['recipients']); ?>
                    </div>
                <?php endif; ?>
                <?php echo $view['form']->widget($form['recipients']); ?>
            </div>
        </div>
        <div class="row">
            <div class="columns">
                <label>
                    <?php echo $view['translator']->trans('contactEdit.fields'); ?>:
                </label>
                <table>
                    <thead>
                        <tr>
                            <th></th>
                            <th><?php echo $view['translator']->trans('contactEdit.table.name'); ?></th>
                            <th><?php echo $view['translator']->trans('contactEdit.table.value'); ?></th>
                            <th><?php echo $view['translator']->trans('contactEdit.table.label'); ?></th>
                            <th><?php echo $view['translator']->trans('contactEdit.table.placeholder'); ?></th>
                            <th><?php echo $view['translator']->trans('contactEdit.table.options'); ?></th>
                            <th><?php echo $view['translator']->trans('contactEdit.table.formFieldType'); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody class="formFields" id="collection"
                           data-prototype="<?php echo $view->escape($view->render(
                        'WiAdminContactBundle:Contact:Components/prototypeFields.html.php',
                        array('field' => $form['fields']->vars['prototype']))); ?>">
                        <?php foreach ($form['fields'] as $key=>$field): ?>
                            <tr id="child-<?php echo $key; ?>" >
                                <td>
                                    <div class="buttonsArrows">
                                        <span class="collection-action collection-up button tiny secondary arrowUp">
                                            <i class="icon-up-big margin-center"></i>
                                        </span>
                                        <span class="collection-action collection-down button tiny secondary arrowDown">
                                            <i class="icon-down-big margin-center"></i>
                                        </span>
                                    </div>
                                    <?php echo $view['form']->row($field['orderNr']) ?>
                                </td>
                                <td>
                                    <?php echo $view['form']->row($field['name']) ?>
                                </td>
                                <td>
                                    <?php echo $view['form']->row($field['value']) ?>
                                </td>
                                <td>
                                    <?php echo $view['form']->row($field['label']) ?>
                                </td>
                                <td>
                                    <?php echo $view['form']->row($field['placeholder']) ?>
                                </td>
                                <td>
                                    <?php echo $view['form']->row($field['identity']) ?>
                                    <?php echo $view['form']->row($field['required']) ?>
                                </td>
                                <td>
                                    <?php echo $view['form']->row($field['formFieldType']) ?>
                                </td>
                                <td>
                                    <a href="#" class="collection-remove collection-action button tiny alert urlRemoveField" title="Remove"><i class="icon-cancel-circled2"></i></a>
                                </td>
                            </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
                <div class="row">
                    <div class="columns text-center hide saveChangeInfo">
                        <p><?php echo $view['translator']->trans('contactEdit.table.saveChange'); ?></p>
                    </div>
                </div>
                <div class="row">
                    <div class="columns small-6">
                        <a href="#" class="button collection-action collection-add" data-collection="collection"><i class="icon-doc-add"></i><?php echo $view['translator']->trans('contactEdit.table.addNewField'); ?></a>
                    </div>
                    <div class="columns small-6 text-right">
                        <button class="button tiny previewFormClick" type="button">
                            <i class="icon-eye"></i>
                            <?php echo $view['translator']->trans('contactEdit.seePreview'); ?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="columns">
                <div class="reveal previewFormReveal" id="previewForm" data-reveal>
                    <div class="previewReplayBox">
                        <div class="titleSmall">
                            <?php echo $view['translator']->trans('contactEdit.formPreview'); ?>
                        </div>
                        <div class="previewForm">

                        </div>
                    </div>
                    <button class="close-button" data-close aria-label="Close modal" type="button">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-bitbucket"></i>
            <span><?php echo $view['translator']->trans('contactEdit.recaptchaTitle'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns medium-6">
                <?php echo $view['form']->label($form['recaptcha']); ?>
                <?php if ($view['form']->errors($form['recaptcha'])): ?>
                    <div class="callout small alert">
                        <?php echo $view['form']->errors($form['recaptcha']); ?>
                    </div>
                <?php endif; ?>
                <div class="switch-admin editFormSwitch">
                    <?php echo $view['form']->widget($form['recaptcha']); ?>
                    <label class="switch-paddle" for="<?php echo $form->children['recaptcha']->vars['id']; ?>">
                        <span class="show-for-sr"><?php echo $view['translator']->trans('contactEdit.recaptchaLabel'); ?></span>
                        <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                        <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                    </label>
                </div>
            </div>
            <div class="columns medium-6">
                <div class="recaptchaKey <?php echo ! empty($Form->getRecaptcha()) ? '' : 'hide'; ?>">
                    <label for="">
                        <?php echo $view['translator']->trans('contactEdit.reCaptchaKey'); ?>:
                    </label>
                    <?php echo $view['form']->label($form['siteKey']); ?>
                    <?php if ($view['form']->errors($form['siteKey'])): ?>
                        <div class="callout small alert">
                            <?php echo $view['form']->errors($form['siteKey']); ?>
                        </div>
                    <?php endif; ?>
                    <?php echo $view['form']->widget($form['siteKey']); ?>

                    <?php echo $view['form']->label($form['secretKey']); ?>
                    <?php if ($view['form']->errors($form['secretKey'])): ?>
                        <div class="callout small alert">
                            <?php echo $view['form']->errors($form['secretKey']); ?>
                        </div>
                    <?php endif; ?>
                    <?php echo $view['form']->widget($form['secretKey']); ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="columns">
                <label for="">
                    <?php echo $view['translator']->trans('contactEdit.moreInfoRecaptcha'); ?>:
                </label>
                <a href="https://www.google.com/recaptcha/" target="_blank" class="moreRecaptchaUrl">www.google.com/recaptcha/</a>
            </div>
        </div>
    </div>
</div>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-retweet"></i>
            <span><?php echo $view['translator']->trans('contactEdit.replayTitle'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns medium-3">
                <?php echo $view['form']->label($form['autoreply']); ?>
                <?php if ($view['form']->errors($form['autoreply'])): ?>
                    <div class="callout small alert">
                        <?php echo $view['form']->errors($form['autoreply']); ?>
                    </div>
                <?php endif; ?>
                <div class="switch-admin editFormSwitch">
                    <?php echo $view['form']->widget($form['autoreply']); ?>
                    <label class="switch-paddle" for="<?php echo $form->children['autoreply']->vars['id']; ?>">
                        <span class="show-for-sr"><?php echo $view['translator']->trans('contactEdit.replayLabel'); ?></span>
                        <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                        <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                    </label>
                </div>
            </div>
            <div class="columns medium-4 end">
                <div class="replySubjectBox <?php echo ! empty($Form->getAutoreply()) ? '' : 'hide'; ?>">
                    <?php echo $view['form']->label($form['replySubject']); ?>
                    <?php if ($view['form']->errors($form['replySubject'])): ?>
                        <div class="callout small alert">
                            <?php echo $view['form']->errors($form['replySubject']); ?>
                        </div>
                    <?php endif; ?>
                    <?php echo $view['form']->widget($form['replySubject']); ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="columns medium-7">
                <div class="contentReplay <?php echo ! empty($Form->getAutoreply()) ? '' : 'hide'; ?>">
                    <?php echo $view['form']->label($form['replyMessage']); ?>
                    <?php if ($view['form']->errors($form['replyMessage'])): ?>
                        <div class="callout small alert">
                            <?php echo $view['form']->errors($form['replyMessage']); ?>
                        </div>
                    <?php endif; ?>
                    <?php echo $view['form']->widget($form['replyMessage']); ?>
                </div>
            </div>
            <div class="columns medium-5">
                <div class="contentReplay <?php echo ! empty($Form->getAutoreply()) ? '' : 'hide'; ?>">
                    <div class="previewReplayBox">
                        <div class="titleSmall">
                            <?php echo $view['translator']->trans('contactEdit.emailPreview'); ?>
                        </div>
                        <div class="previewReplay">
                            <?php echo $Form->getReplyMessage(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="box">
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns">
                <button class="button submitForm" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                    <i class="icon-edit"></i>
                    <?php echo $view['translator']->trans('Form.send'); ?>
                </button>
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_contact_index_form', ['id' => $Form->getId()]); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
            </div>
        </div>
    </div>
</div>
<?php echo $view['form']->widget($form); ?>
<?php echo $view['form']->end($form); ?>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop() ?>
