<?php

namespace Wi\Admin\ContactBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * FormRepository
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class FormRepository extends EntityRepository
{
    /**
     * Liczba wszystkich aktywnych formularzy.
     *
     * @return int
     */
    public function countActive()
    {
        $qb = $this->createQueryBuilder('f');

        return (int) $qb
            ->select($qb->expr()->count('f'))
            ->getQuery()
            ->getSingleScalarResult()
            ;
    }
    
    /**
     * Pobiera formularze na podstawie przekazanego typu formularza.
     *
     * @param string $type
     * @return array
     */
    public function findByFormType($type)
    {
        return $this->createQueryBuilder('f')
            ->where('f.type = :type')
            ->setParameters([
                'type' => $type,
            ])
            ->getQuery()
            ->getResult()
        ;
    }

    /**
     * Pobiera aktualn formularz.
     *
     * @return Form|null
     */
    public function findFirst()
    {
        return $this->createQueryBuilder('f')
            ->getQuery()
            ->setMaxResults(1)
            ->getOneOrNullResult()
        ;
    }
}
