<?php

namespace Wi\Admin\ContactBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\ContactBundle\Entity\Form;

/**
 * Form new type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class FormNewType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'attr' => [
                    'placeholder' => 'contactNew.name',
                ],
                'label' => 'contactNew.nameLabel'
            ])
            ->add('type', ChoiceType::class, [
                'attr' => [
                    'class' => 'select2required',
                ],
                'choices' => [
                    'contactNew.choiseContact' => Form::TYPE_CONTACT,
                    'contactNew.choiseCTA' => Form::TYPE_LEAD,
                ],
                'required' => true,
                'label' => 'contactNew.typeLabel',
                'placeholder' => 'contactNew.type',
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Form::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_contactbundle_form';
    }
}
