<?php

namespace Wi\Admin\ContactBundle\Form;

use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\ContactBundle\Entity\FormField;

/**
 * Form field type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class FormFieldType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'attr' => [
                    'placeholder' => 'contactEdit.table.namePlace',
                ],
                'label' => false,
            ])
            ->add('value', TextType::class, [
                'attr' => [
                    'placeholder' => 'contactEdit.table.value',
                    'class' => 'fieldValue',
                ],
                'required' => false,
                'label' => false,
            ])
            ->add('label', TextType::class, [
                'attr' => [
                    'placeholder' => 'contactEdit.table.labelPlace',
                    'class' => 'fieldLabel',
                ],
                'required' => false,
                'label' => false,
            ])
            ->add('placeholder', TextType::class, [
                'attr' => [
                    'placeholder' => 'contactEdit.table.placeholder',
                    'class' => 'fieldPlace',
                ],
                'required' => false,
                'label' => false,
            ])
            ->add('required', CheckboxType::class, [
                'attr' => [
                    'class' => 'fieldRequ',
                ],
                'required' => false,
                'label' => 'contactEdit.table.required'
            ])
            ->add('identity', CheckboxType::class, [
                'label' => 'contactEdit.table.identity',
                'required' => false,
            ])
            ->add('orderNr', HiddenType::class, [
                'attr' => [
                    'class' => 'orderNrVal'
                ]
            ])
            ->add('formFieldType', EntityType::class, [
                'attr' => [
                    'class' => 'fieldType',
                ],
                'choice_label' => 'title',
                'class' => 'WiAdminContactBundle:FormFieldType',
                'choice_attr' => function ($val, $key, $index) {
                    return [
                        'data-identity' => (int) $val->getIdentity(),
                        'data-type' => $val->getType(),
                    ];
                },
                'label' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => FormField::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_contactbundle_form_field';
    }
}
