<?php

namespace Wi\Admin\ContactBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Wi\Admin\ContactBundle\Entity\Answer;
use Wi\Admin\ContactBundle\Entity\FormField;

/**
 * AnswerField
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(name="contact_answerFields")
 * @ORM\Entity(repositoryClass="Wi\Admin\ContactBundle\Repository\AnswerFieldRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class AnswerField
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var Answer
     *
     * @ORM\ManyToOne(targetEntity="\Wi\Admin\ContactBundle\Entity\Answer", inversedBy="fields")
     * @ORM\JoinColumn(name="answer_id", referencedColumnName="id", nullable=false)
     */
    private $answer;

    /**
     * @var FormField
     *
     * @ORM\ManyToOne(targetEntity="\Wi\Admin\ContactBundle\Entity\FormField")
     * @ORM\JoinColumn(name="field_id", referencedColumnName="id", nullable=false)
     */
    private $field;

    /**
     * @var string
     *
     * @ORM\Column(name="fieldValue", type="string", length=256, nullable=true)
     */
    private $fieldValue;

    /**
     * @var string
     *
     * @ORM\Column(name="fieldTextValue", type="text", nullable=true)
     */
    private $fieldTextValue;

    /**
     * @var string
     *
     * @ORM\Column(name="fieldFileValue", type="string", length=256, nullable=true)
     */
    private $fieldFileValue;

    /**
     * @var bool
     *
     * @ORM\Column(name="isReply", type="boolean")
     */
    private $isReply;


    // ------------------------------------------------------------
    // Has Lifecycle Callbacks methods.
    // ------------------------------------------------------------

    /**
     * Funkcja wykonuje się podczas wstawiania nowego rekordu do bazy.
     *
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        // Ustawienie domyślnie odpowiedzi.
        if (is_null($this->isReply)) {
            $this->isReply = false;
        }
    }

    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set answer
     *
     * @param Answer $answer
     * @return AnswerField
     */
    public function setAnswer(Answer $answer)
    {
        $this->answer = $answer;

        return $this;
    }

    /**
     * Get answer
     *
     * @return Answer
     */
    public function getAnswer()
    {
        return $this->answer;
    }

    /**
     * Set field
     *
     * @param FormField $field
     * @return AnswerField
     */
    public function setField(FormField $field)
    {
        $this->field = $field;

        return $this;
    }

    /**
     * Get field
     *
     * @return FormField
     */
    public function getField()
    {
        return $this->field;
    }

    /**
     * Set fieldValue
     *
     * @param string $fieldValue
     * @return AnswerField
     */
    public function setFieldValue($fieldValue)
    {
        $this->fieldValue = $fieldValue;

        return $this;
    }

    /**
     * Get fieldValue
     *
     * @return string
     */
    public function getFieldValue()
    {
        return $this->fieldValue;
    }

    /**
     * Set fieldTextValue
     *
     * @param string $fieldTextValue
     * @return AnswerField
     */
    public function setFieldTextValue($fieldTextValue)
    {
        $this->fieldTextValue = $fieldTextValue;

        return $this;
    }

    /**
     * Get fieldTextValue
     *
     * @return string
     */
    public function getFieldTextValue()
    {
        return $this->fieldTextValue;
    }

    /**
     * Set fieldFileValue
     *
     * @param string $fieldFileValue
     * @return AnswerField
     */
    public function setFieldFileValue($fieldFileValue)
    {
        $this->fieldFileValue = $fieldFileValue;

        return $this;
    }

    /**
     * Get fieldFileValue
     *
     * @return string
     */
    public function getFieldFileValue()
    {
        return $this->fieldFileValue;
    }

    /**
     * Set isReply
     *
     * @param boolean $isReply
     * @return AnswerField
     */
    public function setIsReply($isReply)
    {
        $this->isReply = $isReply;

        return $this;
    }

    /**
     * Get isReply
     *
     * @return bool
     */
    public function getIsReply()
    {
        return $this->isReply;
    }
}
