<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_block_itemHTML_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.item.New')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/block.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.item'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.New'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-menu-outline"></i><?php echo $view['translator']->trans('item.listTitle'); ?> - <?php echo $view['translator']->trans('itemNew.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('itemNew.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <?php echo $view['form']->start($form, ['attr' => ['id' => 'wi_admin_blockbundle_itemHTML']]); ?>
        <div class="box">
            <div class="box-header bg-transparent">
                <!-- tools box -->
                <h3 class="box-title">
                    <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('itemNew.boxTitle'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body " style="display: block;">
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('itemNew.form.nameTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('itemNew.form.nameDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="medium-6 columns end">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['name']); ?>
                                </div>
                            <?php echo ($view['form']->errors($form['name']) ? $view['form']->widget($form['name'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['name'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('itemNew.form.dateStart'); ?>:</strong></p>
                        <p><?php echo $view['translator']->trans('itemNew.form.dateStartDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="medium-6 columns end">
                                <div class="formAlert">
                                    <?php echo $view['form']->label($form['dateStart']); ?>
                                    <?php echo $view['form']->errors($form['dateStart']); ?>
                                </div>
                            <?php echo ($view['form']->errors($form['dateStart']) ? $view['form']->widget($form['dateStart'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['dateStart'])); ?>
                            </div>
                            <div class="medium-6 columns end">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['dateEnd']); ?>
                                </div>
                                <?php echo $view['form']->label($form['dateEnd']); ?>
                                <?php echo ($view['form']->errors($form['dateEnd']) ? $view['form']->widget($form['dateEnd'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['dateEnd'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('itemNew.form.textTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('itemNew.form.textDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="news-add-form">
                            <div class="formAlert <?php echo ($view['form']->errors($form['content']) ? "callout alert" : ""); ?>">
                                <?php echo $view['form']->errors($form['content']); ?>
                            </div>
                            <div class="formAlert callout alert" id="contentValidation">
                                <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                            </div>
                            <?php echo $view['form']->widget($form['content']); ?>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                    </div>
                    <div class="large-10 columns">
                        <div class="news-add-form">
                            <?php echo $view['form']->widget($form); ?>
                            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                                <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                            </button>
                            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>">
                                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php echo $view['form']->end($form); ?>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/block.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
