<?php

namespace Wi\Admin\BlockBundle\Repository;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\EntityRepository;

/**
 * ItemHTML Repository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ItemHTMLRepository extends EntityRepository
{
    /**
     * Pobiera wszystkie aktywne kategorie.
     *
     * @return ArrayCollection
     */
    public function findAllActive($search = '')
    {
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('i')
            ->where('i.status = :status')
            ->andWhere('i.dateDeleted IS NULL')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
        ];

        // Jeśli tekst do wyszukania jest przekazany to szukaj.
        if ($search) {
            $params['search'] = '%' . $search . '%';
            $qb->andWhere($qb->expr()->orX(
                $qb->expr()->like('i.name', ':search'),
                $qb->expr()->like('i.content', ':search')
            ));
        }

        return new ArrayCollection(
            $qb->setParameters($params)
                ->orderBy('i.orderNr', 'ASC')
                ->addOrderBy('i.name', 'ASC')
                ->getQuery()
                ->getResult()
        );
    }

    /**
    * Get block item for one block.
    *
    * @param   int     $block_id  Block from block.
    * @param   int     $limit        Limit of news.
    * @return  array
    */
    public function findActivByBlockId($block_id, $limit = 5)
    {
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('i')
            ->leftJoin('i.block', 'b')
            ->andWhere('i.dateStart <= :date')
            ->andWhere('i.dateEnd >= :date')
            ->orWhere('i.dateEnd IS NULL')
            ->andWhere('i.dateDeleted IS NULL')
            ->andWhere('i.status = :status')
            ->andWhere('b.id = :block_id')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
            'date' => new \DateTime(),
            'block_id' => $block_id
        ];

        return $qb
            ->orderBy('i.orderNr', 'ASC')
            ->setMaxResults($limit)
            ->setParameters($params)
            ->getQuery()
            ->getResult();
        ;
    }
}
