<?php

namespace Wi\Admin\BlockBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\BlockBundle\Entity\ItemHTML;

/**
 * ItemHTML Creator.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ItemHTMLType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                    'placeholder' => 'blockNew.form.nameTitle',
                ],
                'label' => 'blockNew.form.nameTitle',
            ])
            ->add('content', TextareaType::class, [
                'attr' => [
                    'class' => 'tinyMCE',
                    'maxlength' => 65535,
                    'rows' => 10,
                ],
                'label' => 'content',
                'required' => false,
            ])
            ->add('dateStart', DateTimeType::class, [
                'attr' => [
                    'class' => 'dateStart',
                    'placeholder' => 'blockNew.form.dateStart',
                ],
                'format' => 'dd-MM-yyyy',
                'label' => 'blockNew.form.dateStart',
                'required' => false,
                'widget' => 'single_text',
            ])
            ->add('dateEnd', DateTimeType::class, [
                'attr' => [
                    'class' => 'dateEnd',
                    'placeholder' => 'blockNew.form.dateEnd',
                ],
                'format' => 'dd-MM-yyyy',
                'label' => 'blockNew.form.dateEnd',
                'required' => false,
                'widget' => 'single_text',
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => ItemHTML::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_blockbundle_itemHTML';
    }
}
