<?php

namespace Wi\Admin\BlockBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\BlockBundle\Entity\Block;

/**
 * Block Creator.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BlockNewType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'attr' => [
                    'maxlength' => 256,
                ],
                'label' => 'pagesNew.form.titleTitle',
            ])
            ->add('type', ChoiceType::class, [
                'attr' => [
                    'class' => 'chosenSelect',
                ],
                'choices' => [
                    'User' => Block::TYPE_USER,
                    'Template' => Block::TYPE_TEMPLATE,
                ],
                'label' => 'blockNew.form.typeTitle',
                'required' => true,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Block::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_blockbundle_block_new';
    }
}
