<?php

namespace Wi\Admin\BlockBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\BlockBundle\Entity\ItemHTML;

/**
 * ItemHTML Listener.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ItemHTMLListener
{
    /**
     * Metoda wykonywana jest przed usunięciem obiektu.
     *
     * @param ItemHTML $itemHTML
     * @param LifecycleEventArgs $event
     */
    public function preRemove(ItemHTML $itemHTML, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $itemHTML->setStatus('D');

        // Zapis.
        $em->persist($itemHTML);
        $em->flush();
    }
}
