<?php

namespace Wi\Admin\BlockBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\BlockBundle\Entity\Block;

/**
 * Block Listener.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BlockListener
{
    /**
     * Metoda wykonywana jest przed usunięciem obiektu.
     *
     * @param Block $block
     * @param LifecycleEventArgs $event
     */
    public function preRemove(Block $block, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $block->setStatus('D');

        foreach($block->getItems() as $item) {
            $em->remove($item);
        }

        // Zapis.
        $em->persist($block);
        $em->flush();
    }
}
