<?php

namespace Wi\Admin\BannerBundle\Utils;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Wi\Admin\CoreBundle\Utils\Upload;

/**
 * Upload Banner.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class UploadBannerPhoto extends Upload
{
    /**
     * Construct.
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        // Called to parent construct.
        parent::__construct($container);

        // Get config.
        $config = $container->get('config');

        // Set banner image config.
        $this->config = [
            '' => [
                'width' => (int) $config->get('banner.imageWidth'),
                'height' => (int) $config->get('banner.imageHeight'),
            ],
            'thumbnail' => [
                'width' => (int) $config->get('banner.thumbnailWidth'),
                'height' => (int) $config->get('banner.thumbnailHeight'),
            ]
        ];

        // Set a directory.
        $this->dir = $this->container->getParameter('assets_dirs.banner');
    }
}
