<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_banner_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.bannerSet.Show')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/banner.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>
    
<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_banner_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.bannerSet.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_bannerSet_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.bannerSet.bannerSet'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_bannerSet_show', ['id' => $bannerSet->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.bannerSet.Show'); ?></a>
    </li>
<?php $view['slots']->stop() ?>
    
<?php $view['slots']->start('titleSite') ?>
    <i class="icon-menu-outline"></i><?php echo $view['translator']->trans('bannerSet.listTitle'); ?> - <?php echo $view['translator']->trans('bannerSetShow.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('bannerSetShow.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <?php if ($bannerSet->getId() != 1): ?>
                <div class="pull-right box-tools">
                    <span class="box-btn" data-toggle="configShowPages-dropdown">
                        <i class="icon-cog-5"></i>
                    </span>
                    <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowPages-dropdown" data-dropdown data-close-on-click="true">
                        <ul class="no-bullet">
                            <li>
                                <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                                    <a href="<?php echo $view['router']->path('wi_admin_bannerSet_edit', array('id' => $bannerSet->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                        <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                    </a>
                                <?php endif; ?>
                            </li>
                            <li>
                                <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                                    <a href="<?php echo $view['router']->path('wi_admin_bannerSet_delete', ['id' => $bannerSet->getId()]); ?>">
                                        <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('bannerSetShow.deleteButton'); ?></span>
                                    </a>
                                <?php endif; ?>
                            </li>
                        </ul>
                    </div>
                </div>
            <?php endif; ?>
             <h3 class="box-title"><i class="icon-doc-text-1"></i>
                <span><?php echo $view['translator']->trans('catShow.listSubTitle'); ?> - <?php echo $bannerSet->getName(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: bannerSet;">
             <div class="row">
                <div class="large-10 columns">
                    <br>
                    <p><strong><?php echo $view['translator']->trans('bannerSetNew.form.bannerSetGroup'); ?>:</strong>
                    </p>
                </div>
            </div>
            <hr>
            <?php foreach ($bannerSet->getBanners() as $banner): ?>
                <div class="row">
                    <div class="large-2 columns"> 
                        <a href="<?php echo $view['router']->path('wi_admin_banner_edit', array('id' => $banner->getId())); ?>" title=""><span class="info label secondary showItemButton showHover"><?php echo $banner->getImageURL(); ?></span></a>
                    </div>
                    <div class="large-10 columns">
                        <div class="callout bannerImage">
                            <img src="<?php echo $view['assets']->getUrl('media/assets/Banner/'.$banner->getImageURL()) ; ?>" alt="">
                            <div class="bannerContent">
                                <?php echo $banner->getContent(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
            <?php endforeach; ?>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_bannerSet_edit', array('id' => $bannerSet->getId())); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                            <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                        </a>
                    <?php endif; ?>
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_bannerSet_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/banner.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>