<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_banner_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.banner.Show')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/banner.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_banner_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.bannerSet.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_banner_show', ['id' => $banner->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.banner.Show'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowPages-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowPages-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_banner_edit', array('id' => $banner->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_banner_delete', ['id' => $banner->getId()]); ?>">
                                    <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('bannerShow.deleteButton'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
             <h3 class="box-title"><i class="icon-doc-text-1"></i>
                <span><?php echo $view['translator']->trans('catShow.listSubTitle'); ?> - <?php echo $banner->getImageURL(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
             <div class="row">
                <div class="large-10 columns">
                    <p><strong><?php echo $view['translator']->trans('bannerNew.form.linkUrl'); ?>:</strong>             
                        <?php echo $banner->getLinkURL(); ?>
                    </p>
                    <p><strong><?php echo $view['translator']->trans('bannerNew.form.dateStart'); ?>:</strong>
                        <?php if ($banner->getDateStart()): ?>
                            <?php echo $banner->getDateEnd()->format('Y-m-d H:i:s'); ?>
                        <?php endif; ?>
                    </p>
                    <p><strong><?php echo $view['translator']->trans('bannerNew.form.dateEnd'); ?>:</strong>
                        <?php if ($banner->getDateEnd()): ?>
                            <?php echo $banner->getDateEnd()->format('Y-m-d H:i:s'); ?>
                        <?php endif; ?>
                    </p>
                    <br>
                    <p><strong><?php echo $view['translator']->trans('bannerShow.bannerSetT'); ?>:</strong>
                        <a href="<?php echo $view['router']->path('wi_admin_block_show', ['id' => $banner->getBannerSet()->getId()]); ?>"><span class="info button showPagesButton"><?php echo $banner->getBannerSet()->getName(); ?></span></a>
                    </p>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('bannerNew.form.textTitle'); ?>:</strong></p>
                </div>
                <div class="large-10 columns">
                    <div class="full reveal" id="bannerModal" data-reveal>  
                        <div class="bannerImage">
                            <div>
                                <img class="imgListNews thumbnail" src="<?php echo $view['assets']->getUrl('media/assets/banner/' . $banner->getImageURL()); ?>">
                            </div>
                            <div class="bannerContent"><?php echo $banner->getContent(); ?></div>
                        </div>
                        <button class="close-button" data-close aria-label="Close modal" type="button">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="bannerImage" data-open="bannerModal">
                        <div>
                            <?php if ($banner->getImageURL()): ?>
                                <img class="imgListNews thumbnail" src="<?php echo $view['assets']->getUrl('media/assets/banner/'.$banner->getImageURL()); ?>">
                            <?php endif; ?>
                        </div>
                        <div class="bannerContent showB"><?php echo $banner->getContent(); ?></div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_banner_edit', array('id' => $banner->getId())); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                            <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                        </a>
                    <?php endif; ?>
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_banner_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/banner.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>