<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_banner_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.banner.New')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/banner.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_banner_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.bannerSet.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_banner_new', ['id' => $banner->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.banner.New'); ?></a>
    </li>
<?php $view['slots']->stop() ?>
    
<?php $view['slots']->start('titleSite') ?>
    <i class="icon-menu-outline"></i><?php echo $view['translator']->trans('banner.listTitle'); ?> - <?php echo $view['translator']->trans('bannerNew.subTitle'); ?>
<?php $view['slots']->stop() ?>
    
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('bannerNew.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <?php echo $view['form']->start($form, ['attr' => ['id' => 'wi_admin_bannerbundle_banner']]); ?>
        <div class="box">
            <div class="box-header bg-transparent">
                <!-- tools box -->
                <h3 class="box-title">
                    <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('bannerNew.boxTitle'); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body " style="display: block;">
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('bannerEdit.form.linkTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('bannerEdit.form.linkDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="medium-6 columns end">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['linkURL']); ?>
                                </div>
                            <?php echo ($view['form']->errors($form['linkURL']) ? $view['form']->widget($form['linkURL'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['linkURL'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('bannerNew.form.dateStart'); ?>:</strong></p>
                        <p><?php echo $view['translator']->trans('bannerNew.form.dateStartDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="medium-6 columns end">
                                <div class="formAlert">
                                    <?php echo $view['form']->label($form['dateStart']); ?>
                                    <?php echo $view['form']->errors($form['dateStart']); ?>
                                </div>
                            <?php echo ($view['form']->errors($form['dateStart']) ? $view['form']->widget($form['dateStart'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['dateStart'])); ?>
                            </div>
                            <div class="medium-6 columns end">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['dateEnd']); ?>
                                </div>
                                <?php echo $view['form']->label($form['dateEnd']); ?>
                                <?php echo ($view['form']->errors($form['dateEnd']) ? $view['form']->widget($form['dateEnd'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['dateEnd'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('bannerNew.form.textTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('bannerNew.form.textDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="news-add-form">
                            <div class="formAlert <?php echo ($view['form']->errors($form['content']) ? "callout alert" : ""); ?>">
                                <?php echo $view['form']->errors($form['content']); ?>
                            </div>
                            <div class="formAlert callout alert" id="contentValidation">
                                <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                            </div>
                            <?php echo $view['form']->widget($form['content']); ?>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('bannerEdit.form.imgTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('bannerEdit.form.imgDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="news-add-form">
                            <div class="large reveal" id="windowModalCropper" data-reveal data-close-on-click="false">
                                <div class="containerCropper">
                                    <img id="cropperImage" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg') ?>" alt="">
                                </div>
                                <div class="row buttonAddImage">
                                    <div class="medium-12 columns">
                                        <button type="button" class="button" id="Wyslijfoto" data-close aria-label="Close modal"><i class="icon-ok"></i> <?php echo $view['translator']->trans('newsNew.form.saveImage'); ?></button>
                                        <button type="button" class="button secondary float-right"  data-close aria-label="Close modal"><i class="icon-cancel"></i> <?php echo $view['translator']->trans('Form.backShow'); ?></button>
                                    </div>
                                </div>
                            </div>
                            <?php echo $view['form']->widget($form['crop_x']); ?>
                            <?php echo $view['form']->widget($form['crop_y']); ?>
                            <?php echo $view['form']->widget($form['crop_height']); ?>
                            <?php echo $view['form']->widget($form['crop_width']); ?>
                            <?php echo $view['form']->widget($form['cropSave']); ?>

                            <img id="cropperPreview" class="previewImage thumbnail"  src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg') ?>" alt="" data-open="windowModalCropper">
                            <label class="AddImage" for="wi_admin_bannerbundle_banner_file" >
                                <?php echo $view['form']->widget($form['file'], ['required' => true]); ?>
                                <span class="button" id="imageDataFromParameter" type="button" cropper-width="<?php echo $view['config']->get('banner.imageWidth'); ?>" cropper-height="<?php echo $view['config']->get('banner.imageHeight'); ?>">
                                    <i class="icon-upload"></i><?php echo $view['translator']->trans('newsNew.form.addImage'); ?>
                                </span>
                            </label>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['imageURL']); ?>
                            </div>
                            <div class="hiddenBlock">
                                <?php echo ($view['form']->errors($form['imageURL']) ? $view['form']->widget($form['imageURL'], ['required' => false], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['imageURL'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row metaTags">
                    <div class="box-header bg-transparent">
                        <h3 class="box-title">
                            <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('newsNew.metaTitle'); ?></span>
                        </h3>
                    </div><br>
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('bannerEdit.form.metaTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('bannerEdit.form.metaDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="medium-6 columns end">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['altTitle']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['altTitle']) ? $view['form']->widget($form['altTitle'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['altTitle'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                    </div>
                    <div class="large-10 columns">
                        <div class="news-add-form">
                            <?php echo $view['form']->widget($form); ?>                       
                            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                                <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                            </button>
                            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_banner_index'); ?>">
                                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php echo $view['form']->end($form); ?>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/banner.js') ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.js') ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>