<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_banner_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.banner.Delete')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/banner.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_banner_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.bannerSet.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_banner_delete', array('id' => $banner->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.banner.Delete'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-help-circled"></i><?php echo $view['translator']->trans('banner.listTitle'); ?> - <?php echo $view['translator']->trans('bannerDelete.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('bannerDelete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<div class="box collapsed-box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title">
            <i class="icon-doc-remove"></i>
            <span><?php echo $view['translator']->trans('bannerDelete.listSubTitle'); ?> - <?php echo $banner->getImageURL(); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $view['translator']->trans('bannerDelete.dataNews'); ?></strong></p>

                <?php echo $view['form']->start($deleteForm); ?>
                <?php echo $view['form']->errors($deleteForm); ?>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($deleteForm['deleteBanner']); ?>
                    <?php echo $view['form']->widget($deleteForm['deleteBanner']); ?>
                    <label class="switch-paddle" for="deleteBanner">
                        <span class="show-for-sr"><?php echo $view['translator']->trans('bannerDelete.dataNews'); ?></span>
                        <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                        <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                    </label>
                </div>
                <p><?php echo $view['translator']->trans('bannerDelete.dataNewsSub'); ?>:<br>
                    <strong><?php echo $view['translator']->trans('bannerForm.name'); ?></strong> <?php echo $banner->getImageURL() ?><br>
                </p>
                <button type="submit" id="BannerDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                    <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                </button>
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_banner_show', array('id' => $banner->getId())); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
                <?php echo $view['form']->end($deleteForm); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/banner.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>