<?php

namespace Wi\Admin\BannerBundle\Repository;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\EntityRepository;

/**
 * Banner Repository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BannerRepository extends EntityRepository
{
    /**
     * Pobiera wszystkie aktywne banery.
     *
     * @param string $search
     * @return ArrayCollection
     */
    public function findAllActive($search = '')
    {
         // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('c')
            ->where('c.status = :status')
            ->andWhere('c.dateDeleted IS NULL')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
        ];

         // Jeśli tekst do wyszukania jest przekazany to szukaj.
        if ($search) {
            $params['search'] = '%' . $search . '%';

            $qb->andWhere($qb->expr()->orX(
                $qb->expr()->like('c.imageURL', ':search'),
                $qb->expr()->like('c.content', ':search')
            ));
        }

        return new ArrayCollection(
            $qb->setParameters($params)
                ->orderBy('c.orderNr', 'ASC')
                ->addOrderBy('c.imageURL', 'ASC')
                ->getQuery()
                ->getResult()
            )
        ;
    }

    /**
     * Get banner for one bannerSet.
     *
     * @param   int     $bannerSet_id  BannerSet from bannerSet.
     * @param   int     $limit        Limit of news.
     * @return  array
     */
    public function findActivByBannerSetId($bannerSet_id, $limit = 5)
    {
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('b')
            ->leftJoin('b.bannerSet', 's')
            ->andWhere('b.dateStart <= :date')
            ->andWhere('b.dateEnd >= :date')
            ->orWhere('b.dateEnd IS NULL')
            ->andWhere('b.dateDeleted IS NULL')
            ->andWhere('b.status = :status')
            ->andWhere('s.id = :bannerSet_id')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
            'date' => new \DateTime(),
            'bannerSet_id' => $bannerSet_id
        ];

        return $qb
            ->orderBy('b.orderNr', 'ASC')
            ->setMaxResults($limit)
            ->setParameters($params)
            ->getQuery()
            ->getResult();
        ;
    }
}
