<?php 

namespace Wi\Admin\BannerBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\BannerBundle\Entity\Banner;

/**
 * Banner Listener.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BannerListener
{
    /**
     * Metoda wykonywana jest przed usunięciem obiektu.
     *
     * @param   Banner            $banner
     * @param   LifecycleEventArgs  $event
     */
    public function preRemove(Banner $banner, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $banner->setStatus('D');

        // Zapis.
        $em->persist($banner);
        $em->flush();
    }
}