<?php

namespace Wi\Admin\BannerBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\BannerBundle\Entity\BannerSet;
use Wi\Admin\BannerBundle\Form\BannerSetType;
use Wi\Admin\BannerBundle\Form\BannerSetDeleteType;

/**
 * Blocks controller.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BannerSetController extends Controller
{
    /**
     * Lists all bannerSet entities.
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Pobranie zestawów.
        $bannerSet = $em->getRepository('WiAdminBannerBundle:BannerSet')->findAll();

        return $this->render('WiAdminBannerBundle:BannerSet:index.html.php', [
            'bannerSet' => $bannerSet,
        ]);
    }

    /**
     * Creates a new bannerSet entity.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function newAction(Request $request)
    {
        // Utworzenie nowego zestawu.
        $bannerSet = new BannerSet();

        // Generowanie formularza.
        $form = $this->createForm(BannerSetType::class, $bannerSet);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz zosta� przes�any i pomy�lnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
           // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Zapis.
            $em->persist($bannerSet);
            $em->flush();

            return $this->redirectToRoute('wi_admin_bannerSet_show', [
                'id' => $bannerSet->getId(),
            ]);
        }

        return $this->render('WiAdminBannerBundle:BannerSet:new.html.php', [
            'bannerSet' => $bannerSet,
            'form' => $form->createView(),
        ]);
    }

    /**
     * Finds and displays a bannerSet entity.
     *
     * @param BannerSet $bannerSet
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function showAction(BannerSet $bannerSet)
    {
        return $this->render('WiAdminBannerBundle:BannerSet:show.html.php', [
            'bannerSet' => $bannerSet,
        ]);
    }

    /**
     * Displays a form to edit an existing bannerSet entity.
     *
     * @param Request $request
     * @param BannerSet $bannerSet
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function editAction(Request $request, BannerSet $bannerSet)
    {
        // Generowanie formularza.
        $form = $this->createForm(BannerSetType::class, $bannerSet);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Zapis.
            $em->persist($bannerSet);
            $em->flush();

            return $this->redirectToRoute('wi_admin_bannerSet_show', [
                'id' => $bannerSet->getId(),
            ]);
        }

        return $this->render('WiAdminBannerBundle:BannerSet:edit.html.php', [
            'edit_form' => $form->createView(),
            'bannerSet' => $bannerSet,
        ]);
    }

    /**
     * Deletes a bannerSet entity.
     *
     * @param Request $request
     * @param BannerSet $bannerSet
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function deleteAction(Request $request, BannerSet $bannerSet)
    {
        // Generowanie formularza.
        $deleteForm = $this->createForm(BannerSetDeleteType::class, $bannerSet);
        $deleteForm->handleRequest($request);

        // Weryfikacja czy formularz został przesłany i pomyślnie zwalidowany.
        if ($deleteForm->isSubmitted() && $deleteForm->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Usunięcie.
            $em->remove($bannerSet);
            $em->flush();

            return $this->redirectToRoute('wi_admin_bannerSet_index');
        }

        return $this->render('WiAdminBannerBundle:BannerSet:delete.html.php', [
            'deleteForm' => $deleteForm->createView(),
            'bannerSet' => $bannerSet,
        ]);
    }
}
