<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_advertising_block_index')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('ads.meta.title', [], 'ads')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/commercial.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li><a href="<?php echo $view['router']->path('wi_admin_advertising_block_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.ads', [], 'ads'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-megaphone"></i><?php echo $view['translator']->trans('ads.title', [], 'ads'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-megaphone"></i>
            <span><?php echo $view['translator']->trans('ads.title', [], 'ads'); ?></span>
        </h3>
        <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="dropdown-block">
                <i class="icon-cog-5"></i>
            </span>
            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown-block" data-dropdown data-close-on-click="true">
                <ul class="no-bullet">
                    <li>
                        <a href="<?php echo $view['router']->path('wi_admin_advertising_block_new'); ?>">
                            <span><i class="icon-doc-add"></i> <?php echo $view['translator']->trans('ads.title_new', [], 'ads'); ?></span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php foreach ($advertisingBlocks as $i => $advertisingBlock): ?>
    <?php $advertisements = $advertisingBlock->getAdvertisements(); ?>
    <div class="box <?php echo $i != 0 ? 'collapsed-box' : null; ?>">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-megaphone"></i><span><?php echo $advertisingBlock->getName(); ?> (<?php echo $advertisements->count(); ?>) ID: <?php echo $advertisingBlock->getId(); ?></span>
            </h3>
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="dropdown-<?php echo $advertisingBlock->getId(); ?>">
                    <i class="icon-cog-5"></i>
                </span>
                <span>
                    <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown-<?php echo $advertisingBlock->getId(); ?>" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_advertisement_new', ['id' => $advertisingBlock->getId()]); ?>">
                                <span><i class="icon-doc-add"></i> </i><?php echo $view['translator']->trans('ads.advertisement.add', [], 'ads'); ?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_advertising_block_edit', ['id' => $advertisingBlock->getId()]); ?>">
                                <span><i class="icon-edit"> </i><?php echo $view['translator']->trans('ads.title_edit', [], 'ads'); ?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_advertising_block_delete', ['id' => $advertisingBlock->getId()]); ?>">
                                <span><i class="icon-trash"></i> </i><?php echo $view['translator']->trans('ads.title_delete', [], 'ads'); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- /.box-header -->
        <div class="box-body" style="display: <?php echo $i == 0 ? 'block' : 'none'; ?>;">
            <?php if ($advertisements->count() > 0): ?>
                <table class="commercial">
                    <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('ads.table.content', [], 'ads'); ?></th>
                            <th><?php echo $view['translator']->trans('ads.table.details', [], 'ads'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($advertisements as $advertisement): ?>
                        <tr>
                            <td class="content">
                            <?php if ($advertisingBlock->getType() == $advertisingBlock::TYPE_HTML): ?>
                                <?php echo $advertisement->getContent(); ?>
                            <?php else: ?>
                                <img src="<?php echo $view['assets']->getUrL($advertisement->getContent()); ?>" alt="" class="image">
                            <?php endif; ?>
                            </td>
                            <td>
                                <p>
                                    <?php echo $view['translator']->trans('ads.advertisement.created', [], 'ads'); ?>: <strong><?php echo $advertisement->getDateFormat($advertisement->getDateCreated()) ?></strong><br>
                                    <?php echo $view['translator']->trans('ads.advertisement.started', [], 'ads'); ?>: <strong><?php echo $advertisement->getDateFormat($advertisement->getDateStart()) ?></strong><br>
                                    <?php echo $view['translator']->trans('ads.advertisement.ended', [], 'ads'); ?>: <strong><?php echo $advertisement->getDateFormat($advertisement->getDateEnd()) ?></strong><br>
                                    <?php echo $view['translator']->trans('ads.advertisement.status.title', [], 'ads'); ?>: <strong><?php echo $view['translator']->trans('ads.advertisement.status.option.'.$advertisement->getStatus(), [], 'ads'); ?></strong><br>
                                    <?php echo $view['translator']->trans('ads.advertisement.link', [], 'ads'); ?>: <a href="<?php echo $advertisement->getLink(); ?>"><?php echo $advertisement->getLink(); ?></a>
                                </p>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <a href="<?php echo $view['router']->path('wi_admin_advertisement_edit', ['id' => $advertisement->getId()]); ?>" class=""><i class="icon-edit-1"></i>Edit</a>
                                         / <a href="<?php echo $view['router']->path('wi_admin_advertisement_delete', ['id' => $advertisement->getId()]); ?>" class=""><i class="icon-cancel-circled-outline"></i>Delete</a>
                                     </div>
                                 </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif ?>
        </div>
    </div>
<?php endforeach ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/commercial.js') ?>"></script>
<?php $view['slots']->stop(); ?>
