<?php

namespace Wi\Admin\AdvertisingBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\AdvertisingBundle\Entity\AdvertisingBlock;

/**
 * Advertising Block Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class AdvertisingBlockType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'label' => false,
                'required' => true,
            ])
            ->add('description', TextareaType::class, [
                'label' => false,
                'required' => false,
            ])
            ->add('type', ChoiceType::class, [
                'choices' => [
                    'ads.form.type.option.'.AdvertisingBlock::TYPE_HTML => AdvertisingBlock::TYPE_HTML,
                    'ads.form.type.option.'.AdvertisingBlock::TYPE_BANNER => AdvertisingBlock::TYPE_BANNER,
                    'ads.form.type.option.'.AdvertisingBlock::TYPE_SLIDER => AdvertisingBlock::TYPE_SLIDER,
                ],
                'choice_translation_domain' => 'ads',
                'expanded' => false,
                'label' => false,
                'multiple' => false,
                'required' => true,
            ])
            ->add('time')
            ->add('randomDisplay', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input',
                ],
                'label' => false,
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => AdvertisingBlock::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_advertising_block';
    }
}
