<?php

namespace Wi\Admin\AdvertisingBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\AdvertisingBundle\Entity\Advertisement;
use Wi\Admin\AdvertisingBundle\Entity\AdvertisingBlock;

/**
 * Advertising Block Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class AdvertisementType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $advertisingBlock = $builder->getData()->getAdvertisingBlock();

        $builder
            ->add('html', TextareaType::class, [
                'attr' => [
                    'class' => 'editor-html',
                ],
                'required' => false,
            ])
            ->add('image', HiddenType::class, [
                'required' => false,
            ])
            ->add('file', FileType::class, [
                'attr' => [
                    'accept' => '.jpg,.jpeg,.png,.gif',
                    'class' => 'InputFileHidden',
                ],
                'label' => false,
                'mapped' => false,
                'required' => in_array($advertisingBlock->getType(), [AdvertisingBlock::TYPE_BANNER, AdvertisingBlock::TYPE_SLIDER]),
            ])
            ->add('link', TextType::class, [
                'attr' => [
                    'class' => 'link-generator',
                ],
                'required' => false,
            ])
            ->add('dateStart', DateTimeType::class, [
                'attr' => [
                    'class' => 'datePicker',
                ],
                'format' => 'dd-MM-yyyy',
                'required' => false,
                'widget' => 'single_text',
            ])
            ->add('dateEnd', DateTimeType::class, [
                'attr' => [
                    'class' => 'datePicker',
                ],
                'format' => 'dd-MM-yyyy',
                'required' => false,
                'widget' => 'single_text',
            ])
            ->add('status', ChoiceType::class, [
                'choices' => [
                    'ads.advertisement.status.option.'.Advertisement::STATUS_ACTIVE => Advertisement::STATUS_ACTIVE,
                    'ads.advertisement.status.option.'.Advertisement::STATUS_EXPIRED => Advertisement::STATUS_EXPIRED,
                    'ads.advertisement.status.option.'.Advertisement::STATUS_PENDING => Advertisement::STATUS_PENDING,
                ],
                'choice_translation_domain' => 'ads',
                'expanded' => false,
                'label' => false,
                'multiple' => false,
                'data' => $builder->getData()->getStatus() ?? Advertisement::STATUS_PENDING,
                'required' => true,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Advertisement::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_advertisement_block';
    }
}
