<?php

namespace Wi\Admin\AdminBundle\Service;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Http\Authentication\DefaultAuthenticationSuccessHandler;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Http\HttpUtils;
use Wi\Admin\CoreBundle\Utils\StrefaWiCMSAPI;

class AuthenticationSuccessHandler extends DefaultAuthenticationSuccessHandler
{
    /**
     * @var StrefaWiCMSAPI
     */
    private $api;

    /**
     * Identyfikator publiczny instalacji.
     *
     * @var string
     */
    private $publicID;

    /**
     * Constructor.
     *
     * @param HttpUtils $httpUtils
     */
    public function __construct(ContainerInterface $container, HttpUtils $httpUtils, StrefaWiCMSAPI $api)
    {
        $this->api = $api;
        $this->publicID = $container->getParameter('public_id');

        parent::__construct($httpUtils);
    }

    /**
     * {@inheritdoc}
     */
    public function onAuthenticationSuccess(Request $request, TokenInterface $token)
    {
        // Przesłanie zdarzenia logowania do panelu administracyjnego.
        $this->api->eventLoginPost([
            'publicID' => $this->publicID,
            'administrator' => $token->getUser()->getLogin(),
            'server' => $request->server->get('SERVER_ADDR'),
            'domain' => $request->server->get('HTTP_HOST'),
        ]);

        return parent::onAuthenticationSuccess($request, $token);
    }
}
