<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo $view['translator']->trans('login.title'); ?></title>
    <link rel="shortcut icon" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/WiCMS-favicon.png') ?>" />
    <link rel="stylesheet"
          href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Foundation/foundation-sites/dist/css/foundation-float.min.css') ?>"/>
    <!-- Custom styles for this template -->

    <link rel="stylesheet"
          href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/css/Montserrat-Hairline.css') ?>"/>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/login.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">

</head>

<body>

<!-- right sidebar wrapper -->
<div class="inner-wrap">
    <div class="wrap-fluid">
        <div class="row columns">
            <div class="profile">
                <img alt="" class="" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/WiCMS-logo-white-200px.png') ?>">
            </div>

        </div>
        <div class="loginWhite">
            <div class="row">
                <div class="columns text-center">
                    <h1><?php echo $view['translator']->trans('login.nameWiCMS'); ?></h1>
                    <p class="text-center"><?php echo $view['translator']->trans('login.infoWiCMS'); ?></p>
                    <hr>
                </div>
            </div>
            <div class="row">
                <div class="columns text-center formLogin">
                    <h3><?php echo $view['translator']->trans('login.header'); ?></h3>
                    <div class="box float-center">
                        <!-- Profile -->
                        <!-- End of Profile -->
                        <!-- /.box-header -->
                        <div class="box-body " style="display: block;">
                            <div class="row">
                                <div class="large-12 columns">
                                    <div class="row">
                                        <div class="edumix-signup-panel">
                                            <p class="welcome"></p>
                                            <?php if ($error): ?>
                                                <div class="alert callout small"><?php echo $view['translator']->trans($error->getMessage()) ?></div>
                                            <?php endif ?>
                                            <form action="<?php echo $view['router']->path('wi_admin_admin_login') ?>" method="post">
                                                <?php /* ?>
                                                <input type="hidden" name="_csrf_token" value="<?php echo $view['form']->csrfToken('authenticate') ?>">
                                                <?php */ ?>
                                                <div class="row column log-in-form">
                                                    <label>
                                                        <input data-tooltip aria-haspopup="true" class="has-tip left" data-disable-hover="false" tabindex="1" title="<?php echo $view['translator']->trans('login.userDesc'); ?>" type="text" id="username" name="_username" class="float-center"
                                                               value="<?php echo $last_username ?>" placeholder="<?php echo $view['translator']->trans('login.user'); ?>">
                                                    </label>
                                                    <div class="formPasswordShow">
                                                        <label>
                                                            <input data-tooltip aria-haspopup="true" class="has-tip left" data-disable-hover="false" tabindex="1" title="<?php echo $view['translator']->trans('login.passDesc'); ?>" type="password" id="password" class="float-center" name="_password" placeholder="<?php echo $view['translator']->trans('login.pass'); ?>"/> </label>
                                                        <div class="passwordShowButton" id="show-password">
                                                            <i class="icon-eye"></i>
                                                            <i class="icon-eye-off hide"></i>
                                                        </div>
                                                    </div>
                                                    <p><input type="submit" class="button float-center" value="<?php echo $view['translator']->trans('login.button'); ?>"></p>
                                                    <p class="text-center forgotPassword"><a href="<?php echo $view['router']->path('wi_admin_admin_forgot_password') ?>"><?php echo $view['translator']->trans('login.forgotPass'); ?></a></p>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <!-- end .timeline -->
                    </div>
                    <!-- box -->
                </div>
            </div>
            <div class="row">
                <div class="columns">
                    <hr>
                </div>
            </div>
            <div class="row infoBrowser">
                <div class="columns small-12 medium-6">
                    <h2><?php echo $view['translator']->trans('login.correct'); ?></h2>
                    <p><?php echo $view['translator']->trans('login.correctInfo'); ?></p>
                    <div class="rowInfoBrowser">
                        <div class="infoBrowserIcon">
                            <a href="https://www.mozilla.org/pl/firefox/new/" target="_blank" rel="nofollow">
                                <img src="<?php echo $browser['name'] == 'Firefox' ? $view['assets']->getUrl('media/Admin/WiCMS3/img/firefoxActive.png') : $view['assets']->getUrl('media/Admin/WiCMS3/img/firefox.png'); ?>" alt="Mozilla Firefox" class="firefox">
                            </a>
                            <a href="https://www.google.pl/chrome/" target="_blank" rel="nofollow">
                                <img src="<?php echo $browser['name'] == 'Chrome' ? $view['assets']->getUrl('media/Admin/WiCMS3/img/chromeActive.png') : $view['assets']->getUrl('media/Admin/WiCMS3/img/chrome.png') ?>" alt="Google Chrome" class="chrome">
                            </a>
                            <small class="browserName"><?php echo $browser['name'].' '.$browser['version']; ?></small>
                        </div>
                        <div class="infoBrowserText text-left">
                            <div class="correctTest <?php echo $browser['name'] == 'Chrome' || $browser['name'] == 'Firefox' ? '' : 'hide'; ?>">
                                <i class="icon-ok-6"></i>
                                <p><?php echo $view['translator']->trans('login.correctTest'); ?></p>
                            </div>
                            <div class="incorrectTest <?php echo $browser['name'] == 'Chrome' || $browser['name'] == 'Firefox' ? 'hide' : ''; ?>">
                                <i class="icon-attention-alt"></i>
                                <p><?php echo $view['translator']->trans('login.incorrectTest'); ?></p>
                                <p class="incorrectTestInfo"><?php echo $view['translator']->trans('login.incorrectTestInfo'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="columns small-12 medium-6 infoWebsite">
                    <h2><?php echo $view['translator']->trans('login.infoWebsite'); ?></h2>
                    <div class="row">
                        <div class="columns">
                            <i class="icon-mobile-1"></i>
                            <p>
                                <strong><?php echo $view['translator']->trans('login.responsiveLayout'); ?></strong><br>
                                <?php echo $view['translator']->trans('login.responsiveLayoutInfo'); ?>
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="columns">
                            <i class="icon-search"></i>
                            <p>
                                <strong><?php echo $view['translator']->trans('login.seo'); ?></strong><br>
                                <?php echo $view['translator']->trans('login.seoInfo'); ?>
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="columns">
                            <i class="icon-pencil"></i>
                            <p>
                                <strong><?php echo $view['translator']->trans('login.pages'); ?></strong><br>
                                <?php echo $view['translator']->trans('login.pagesInfo'); ?>
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="columns">
                            <i class="icon-chart"></i>
                            <p>
                                <strong><?php echo $view['translator']->trans('login.stats'); ?></strong><br>
                                <?php echo $view['translator']->trans('login.statsInfo'); ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <footer>
            <div class="row">
                <div class="medium-6 columns profile-dol">
                    <a href="http://www.webimpuls.pl" title="<?php echo $view['translator']->trans('footer.wi-link-title'); ?>" class="">
                        <img class="webimpulsLogo" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/WEBimpuls-logo-2015-500px.png') ?>" alt="<?php echo $view['translator']->trans('footer.wi-img-alt'); ?>">
                    </a><br>
                    <a href="http://www.webimpuls.pl" title="<?php echo $view['translator']->trans('footer.wi-link-title'); ?>" class="webimpuls"><?php echo $view['translator']->trans('footer.Copyright'); ?></a>
                    <p><?php echo $view['translator']->trans('footer.CopyrightInfo'); ?></p>
                </div>
                <div class="medium-6 columns profile-dol-right">
                    <h4><?php echo $view['translator']->trans('login.moreInfo'); ?></h4>
                    <ul>
                        <li>
                            <a href="http://www.webimpuls.pl" title="<?php echo $view['translator']->trans('footer.wi-link-title'); ?>"><span><?php echo $view['translator']->trans('login.wi-link'); ?></span></a>
                        </li>
                        <li>
                            <a href="http://www.wicms.pl" title="<?php echo $view['translator']->trans('login.wi-link-wicms'); ?>"><span><?php echo $view['translator']->trans('login.wi-link-wi'); ?></span></a>
                        </li>
                    </ul>
                    <ul>
                        <li>
                            <a title="<?php echo $view['translator']->trans('login.wi-link-help'); ?>"><span><?php echo $view['translator']->trans('login.wi-link-help'); ?></span></a>
                        </li>
                    </ul>
                    <a href="<?php echo $view['router']->path('homepage') ?>" class="button">
                        <?php echo $view['translator']->trans('login.showPage'); ?>
                    </a>
                </div>
            </div>
        </footer>
        <!-- Container Begin -->
    </div>
    <!-- End of Container Begin -->
</div>
<script type='text/javascript'
        src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery.min.js') ?>"></script>
<script type='text/javascript' src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/login.js') ?>"></script>
<script type='text/javascript' src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/foundation.min.js') ?>"></script>
<script>
    $(document).foundation();
</script>

</body>

</html>
