<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_admin_administrators_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.adminShow')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/admin.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.administration'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.Administrators'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_show', array('id' => $administrator->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.AdminShow'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-users-outline"></i><?php echo $view['translator']->trans('admin.listTitle'); ?> - <?php echo $view['translator']->trans('adminShow.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('adminShow.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configAdmin-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configAdmin-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_ADMINISTRATORS_EDIT')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_edit', array('id' => $administrator->getId())); ?>"
                                   class="" title="<?php echo $view['translator']->trans('adminShow.editButton'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('adminShow.editButton'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if ($view['security']->isGranted('ROLE_ADMINISTRATORS_EDIT_PERMISSIONS')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_edit_permission', array('id' => $administrator->getId())); ?>" class=""
                                   title="<?php echo $view['translator']->trans('adminShow.editPerButton'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('adminShow.editPerButton'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if ($view['security']->isGranted('ROLE_ADMINISTRATORS_DELETE')): ?>
                            <?php if ($administrator->getlogin() != $app->getUser()->getUsername()) : ?>
                                <li>
                                    <a class="" href="<?php echo $view['router']->path('wi_admin_admin_administrators_delete', array('id' => $administrator->getId())); ?>">
                                        <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('adminShow.deleteButton'); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-user-outline"></i>
                <span><?php echo $view['translator']->trans('adminShow.listSubTitle'); ?>
                    - <?php echo(!empty($administrator->getFirstName()) ? $administrator->getFirstName() . ' ' . $administrator->getlastName() : $administrator->getLogin()); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('adminShow.dataAdmin'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('adminShow.dataAdminSub'); ?></p>
                </div>
                <div class="large-10 columns">
                    <p><strong><?php echo $view['translator']->trans('adminData.login'); ?>
                            :</strong> <?php echo $administrator->getLogin(); ?></p>
                    <p><strong><?php echo $view['translator']->trans('adminData.email'); ?>
                            :</strong> <?php echo $administrator->getEmail(); ?></p>
                    <p><strong><?php echo $view['translator']->trans('adminData.Name'); ?>
                            :</strong> <?php echo $administrator->getFirstName() . ' ' . $administrator->getlastName(); ?>
                    </p>
                    <p><strong><?php echo $view['translator']->trans('adminData.displayName'); ?>
                            :</strong> <?php echo $administrator->getDisplayName(); ?></p>
                    <p><strong><?php echo $view['translator']->trans('adminData.job'); ?>
                            :</strong> <?php echo $administrator->getJob(); ?></p>
                </div>
            </div>
            <?php if ($view['security']->isGranted('ROLE_ADMINISTRATORS_EDIT_PERMISSIONS')): ?>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('adminShow.role'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('adminShow.roleDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <ul>
                        <?php foreach ($administrator->getRoles() as $role): ?>
                            <li>
                                <?php echo $view['translator']->trans($role); ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    <?php if ($view['security']->isGranted('ROLE_ADMINISTRATORS_EDIT_PERMISSIONS')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_edit_permission', array('id' => $administrator->getId())); ?>" class="button tiny">
                            <span><i class="icon-edit"></i><?php echo $view['translator']->trans('adminShow.editPerButton'); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
            <hr>
            <div class="row">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_admin_administrators_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
        <!-- end .timeline -->
    </div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/admin.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
