<?php

namespace Wi\Admin\AdminBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\AdminBundle\Entity\Administrator;

/**
 * Administrator Listener.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class AdministratorListener
{
    /**
     * Funkcja wykonuje się przed usunięciem rekordu.
     *
     * @param  Administrator       $administrator
     * @param  LifecycleEventArgs  $event
     */
    public function preRemove(Administrator $administrator, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $administrator->setStatus('D');

        // Zapis.
        $em->persist($administrator);
        $em->flush();
    }
}
