<?php

namespace Wi\Admin\AdminBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\AdminBundle\Entity\Role;

/**
 * Załadowanie roli do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadRoleData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $role = $this->getRole($data);
            $this->addReference('ab-role-'.$data['id'], $role);

            // Przygotowanie do zapisu.
            $manager->persist($role);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($role));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 6;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            ['id' => 1, 'type' => 'ROLE_ADMINISTRATORS_INDEX'],
            ['id' => 2, 'type' => 'ROLE_ADMINISTRATORS_EDIT'],
            ['id' => 3, 'type' => 'ROLE_ADMINISTRATORS_EDIT_PERMISSIONS'],
            ['id' => 4, 'type' => 'ROLE_ADMINISTRATORS_DELETE'],
            ['id' => 5, 'type' => 'ROLE_NEWS_INDEX'],
            ['id' => 6, 'type' => 'ROLE_NEWS_EDIT'],
            ['id' => 7, 'type' => 'ROLE_PAGES_INDEX'],
            ['id' => 8, 'type' => 'ROLE_PAGES_EDIT'],
            ['id' => 9, 'type' => 'ROLE_MEDIA_INDEX'],
            ['id' => 10, 'type' => 'ROLE_MEDIA_EDIT'],
            ['id' => 11, 'type' => 'ROLE_USERS_INDEX'],
            ['id' => 12, 'type' => 'ROLE_USERS_EDIT'],
            ['id' => 13, 'type' => 'ROLE_NEWSLETTER_INDEX'],
            ['id' => 14, 'type' => 'ROLE_NEWSLETTER_EDIT'],
            ['id' => 20, 'type' => 'ROLE_MENU_INDEX'],
            ['id' => 21, 'type' => 'ROLE_MENU_EDIT'],
            ['id' => 22, 'type' => 'ROLE_FAQ_INDEX'],
            ['id' => 23, 'type' => 'ROLE_FAQ_EDIT'],
            ['id' => 24, 'type' => 'ROLE_BLOCKS_INDEX'],
            ['id' => 25, 'type' => 'ROLE_BLOCKS_EDIT'],
            ['id' => 26, 'type' => 'ROLE_BANNER_INDEX'],
            ['id' => 27, 'type' => 'ROLE_BANNER_EDIT'],
            ['id' => 28, 'type' => 'ROLE_REST_API_DOC'],
            ['id' => 29, 'type' => 'ROLE_SEO_INDEX'],
            ['id' => 30, 'type' => 'ROLE_CONTACT_INDEX'],
            ['id' => 31, 'type' => 'ROLE_CONTACT_EDIT'],
            ['id' => 32, 'type' => 'ROLE_CONFIGURATION_INDEX'],
            ['id' => 33, 'type' => 'ROLE_BACKUP_INDEX'],
            ['id' => 34, 'type' => 'ROLE_BACKUP_FULL'],
            ['id' => 35, 'type' => 'ROLE_BLOG_INDEX'],
            ['id' => 36, 'type' => 'ROLE_BLOG_EDIT'],
            ['id' => 37, 'type' => 'ROLE_LINK_INDEX'],
            ['id' => 38, 'type' => 'ROLE_ADVERTISEMENT_INDEX'],
            ['id' => 39, 'type' => 'ROLE_ADVERTISEMENT_EDIT'],
            ['id' => 40, 'type' => 'ROLE_FILE_INDEX'],
            ['id' => 41, 'type' => 'ROLE_FILE_EDIT'],
        ];
    }

    /**
     * Tworzy obiekt nowej roli na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\AdminBundle\Entity\Role
     */
    private function getRole(array $data)
    {
        return (new Role())
            ->setId($data['id'])
            ->setType($data['type'])
        ;
    }
}
