<?php

namespace Wi\Admin\AdminBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\AdminBundle\Entity\Administrator;

/**
 * Załadowanie roli do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadAdministratorData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $administrator = $this->getAdministrator($data);
            $this->addReference('ab-administrator-'.$data['id'], $administrator);

            // Przygotowanie do zapisu.
            $manager->persist($administrator);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($administrator));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 7;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'login' => 'admin',
                'password' => '$2y$13$JcH4.kDLft9x/p62KuQmcu/A2Zz9qZCDzYGrPz72eHTzWn.bYjRa.',
                'firstName' => 'admin',
                'lastName' => null,
                'email' => 'jakub.nowak@webimpuls.pl',
                'job' => '',
                'hash' => null,
                'hashExpired' => null,
                'locale' => 'en',
            ],
            [
                'id' => 2,
                'login' => 'demo',
                'password' => '$2y$13$JcH4.kDLft9x/p62KuQmcu/A2Zz9qZCDzYGrPz72eHTzWn.bYjRa.',
                'firstName' => 'demo',
                'lastName' => null,
                'email' => 'piotr.krzok@webimpuls.pl',
                'job' => '',
                'hash' => null,
                'hashExpired' => null,
                'locale' => 'pl',
            ],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\AdminBundle\Entity\Administrator
     */
    private function getAdministrator(array $data)
    {
        return (new Administrator())
            ->setId($data['id'])
            ->setLogin($data['login'])
            ->setPassword($data['password'])
            ->setDateCreated(new \DateTime())
            ->setStatus('A')
            ->setFirstName($data['firstName'])
            ->setLastName($data['lastName'])
            ->setEmail($data['email'])
            ->setJob($data['job'])
            ->setHash($data['hash'])
            ->setHashExpired($data['hashExpired'])
            ->setLocale($data['locale'])
        ;
    }
}
