<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title><?php $view['slots']->output('title', 'WiCMS 3.0') ?></title>
    <meta name="robots" content="noindex, nofollow">
    <link rel="shortcut icon" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/WiCMS-logo-white-200px-small.png') ?>" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/szablon.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
    <!-- Wczytanie css z widoku akcji -->
    <?php $view['slots']->output('stylesheets') ?>
</head>

<body>
<script>
    var base_url = "<?php echo $view['config']->getParameter('base_url'); ?>";
</script>
<?php $stats = $view['front']->getStats(); ?>
<span id="assetsBaseDir" data-assetsbasedir="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/') ?>"></span>
<span id="pathInfo" data-pathInfo="<?php echo $app->getRequest()->getPathInfo(); ?>"></span>
<span id="inboxInfo" data-inboxcontactmenu="<?php echo $stats['formCountContactAnswer']; ?>" data-inboxleadmenu="<?php echo $stats['formCountLeadAnswer']; ?>"></span>
<!-- preloader -->
<div id="preloader">
    <div id="status">&nbsp;</div>
</div>
<!-- End of preloader -->
<div class="off-canvas-wrapper over-flow-hidden">
    <div class="off-canvas-wrapper-inner " data-off-canvas-wrapper>
        <!-- right sidebar wrapper -->
        <div class="inner-wrap">
            <!-- Right sidemenu -->
            <?php //echo $active_menu; ?>
            <?php echo $view->render('Components/main-menu.html.php', array('menuIsActive' => $menuIsActive)) ?>

            <!-- end of Rightsidemenu -->
            <div class="wrap-fluid" id="paper-bg">
                <!-- Top Nav -->
                <?php echo $view->render('Components/top-bar.html.php') ?>

                <!-- end of Top Nav -->
                <!-- breadcrumbs -->
                <div class="breadcrumbsBox">
                    <div class="row">
                        <div class="columns small-12 medium-8">
                            <ul class="breadcrumbs">
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_admin_dashboard'); ?>" title="<?php echo $view['translator']->trans('breadcrumbs.WiCMS'); ?>">
                                        <span class="icon-home"></span>
                                    </a>
                                </li>
                                <?php $view['slots']->output('breadcrumbs') ?>
                            </ul>
                        </div>
                        <div class="columns small-12 medium-4">
                            <form action="<?php echo $view['router']->path('wi_admin_core_search_index'); ?>" class="searchForm" method="get">
                                <input type="search" name="search" id="search" placeholder="<?php echo $view['translator']->trans('top-bar.searchForm'); ?>">
                                <button type="submit"><i class="icon-search"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- end of breadcrumbs -->
                <div class="top-main-fondamix">
                    <!-- Begin page content -->
                </div>
                <div class="row">
                    <div class="large-12 columns">
                        <h1 class="titleSite">
                            <?php $view['slots']->output('titleSite') ?>
                        </h1>
                        <p><?php $view['slots']->output('titleDesc') ?></p>
                        <!-- BODY
                            ###################################################################################################################################
                            -->
                        <?php $view['slots']->output('body') ?>
                    </div>
                </div>
                <!-- Widget  -->
                <div class="row">
                    <div class="large-4 columns"></div>
                    <!-- /.box -->
                </div>
                <!-- End of Widget  -->
            </div>
            <footer>
                <?php echo $view->render('Components/footer.html.php') ?>
            </footer>

            <div class="reveal" id="ajaxSuggestions" data-reveal data-ajaxError="<?php echo $view['translator']->trans('suggestion.errorAjax'); ?>">

            </div>
            <div class="reveal" id="changePassword" data-reveal>
               <div class="row">
                   <div class="columns">
                       <h3><?php echo $view['translator']->trans('top-bar.changePassword'); ?></h3>
                       <div class="callout success hide successPasswordReset">
                           <?php echo $view['translator']->trans('top-bar.successPasswordReset'); ?>
                       </div>
                       <div class="callout alert hide errorPasswordReset">
                           <?php echo $view['translator']->trans('top-bar.errorPasswordReset'); ?>
                       </div>
                       <form data-abide novalidate id="resetPasswordModal">
                           <div class="row">
                               <div class="small-12 columns">
                                   <label><?php echo $view['translator']->trans('top-bar.password'); ?>
                                       <input type="password" id="passwordModal" placeholder="<?php echo $view['translator']->trans('top-bar.password'); ?>" aria-describedby="exampleHelpText" required >
                                       <span class="form-error">
                                            <?php echo $view['translator']->trans('top-bar.required'); ?>
                                       </span>
                                   </label>
                               </div>
                               <div class="small-12 columns">
                                   <label><?php echo $view['translator']->trans('top-bar.reenterpassword'); ?>
                                       <input type="password" placeholder="<?php echo $view['translator']->trans('top-bar.password'); ?>" aria-describedby="exampleHelpText2" required pattern="alpha_numeric" data-equalto="passwordModal" id="repasswordModal">
                                       <span class="form-error">
                                           <?php echo $view['translator']->trans('top-bar.passwordTheSame'); ?>
                                       </span>
                                   </label>
                               </div>
                           </div>
                           <button class="button float-right" type="submit" value="Submit">
                               <span>
                                   <?php echo $view['translator']->trans('Form.send'); ?>
                               </span>
                           </button>
                       </form>
                   </div>
               </div>
                <button class="close-button" data-close aria-label="Close modal" type="button">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="reveal" id="changeLanguage" data-reveal>
                <div class="row">
                    <div class="columns">
                        <h3><?php echo $view['translator']->trans('top-bar.changeLanguage'); ?></h3>
                        <form action="">
                            <div class="row">
                                <div class="columns small-3">
                                    <div class="switch">
                                        <input class="switch-input inputLanguage" id="en" type="radio" <?php echo $app->getUser()->getLocale() == 'en' ? 'checked' : ''; ?> name="Language" value="en">
                                        <label class="switch-paddle" for="en">
                                            <span class="show-for-sr"><?php echo $view['translator']->trans('top-bar.langEn'); ?></span>
                                            <span class="switch-active" aria-hidden="true">En</span>
                                            <span class="switch-inactive" aria-hidden="true">En</span>
                                        </label>
                                    </div>
                                </div>
                                <div class="columns small-9">
                                    <p><?php echo $view['translator']->trans('top-bar.langEn'); ?></p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="columns small-3">
                                    <div class="switch">
                                        <input class="switch-input inputLanguage" <?php echo $app->getUser()->getLocale() == 'pl' ? 'checked' : ''; ?> id="pl" type="radio" name="Language" value="pl">
                                        <label class="switch-paddle" for="pl">
                                            <span class="show-for-sr"><?php echo $view['translator']->trans('top-bar.langPL'); ?></span>
                                            <span class="switch-active" aria-hidden="true">Pl</span>
                                            <span class="switch-inactive" aria-hidden="true">Pl</span>
                                        </label>
                                    </div>
                                </div>
                                <div class="columns small-9">
                                    <p><?php echo $view['translator']->trans('top-bar.langPL'); ?></p>
                                </div>
                            </div>
                            <button class="button float-right buttonSaveLanguage" type="button">
                                <span>
                                    <?php echo $view['translator']->trans('Form.send'); ?>
                                </span>
                            </button>
                        </form>
                </div>
                <button class="close-button" data-close aria-label="Close modal" type="button">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            </div>
            <!-- End of Container Begin -->
            <!-- Right Menu -->
            <?php echo $view->render('Components/right-menu.html.php'); ?>
            <!-- End of Right Menu -->
        </div>
        <!-- end paper bg -->
    </div>
</div>
<!-- end of off-canvas-wrap -->
<!-- end of inner-wrap -->
<?php /* FOSJsRoutingBundle */ ?>
<script src="<?php echo $view['assets']->getUrl('bundles/fosjsrouting/js/router.js') ?>"></script>
<script src="<?php echo $view['router']->path('fos_js_routing_js', array('callback' => 'fos.Router.setData')) ?>"></script>
<!-- main javascript library -->
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/jquery.js') ?>"></script>
<!--<script src="--><?php //echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Foundation/jquery/dist/jquery.min.js') ?><!--"></script>-->
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/pace/pace.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/vendor/modernizr.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/waypoints.min.js') ?>"></script>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/preloader-script.js') ?>'></script>
<!-- foundation javascript -->
<!--<script src="--><?php //echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/foundation/what-input.js') ?><!--"></script>-->
<!--<script src="--><?php //echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/foundation.min.js') ?><!--"></script>-->
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Foundation/foundation-sites/dist/js/foundation.min.js') ?>'></script>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Foundation/what-input/dist/what-input.js') ?>'></script>

<!-- main edumix javascript -->
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/slimscroll/jquery.slimscroll.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/slicknav/jquery.slicknav.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/sliding-menu.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/scriptbreaker-multiple-accordion-1.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/number/jquery.counterup.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/circle-progress/jquery.circliful.min.js') ?>"></script>
<!-- additional javascript -->
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/number-progress-bar/jquery.velocity.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/number-progress-bar/number-pb.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/loader/loader.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/loader/demo.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/skycons/skycons.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/link-generator/js/jquery.link-generator.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/jqueryUI-autocomplited/jquery-ui.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/app.js') ?>"></script>
<!-- Wczytanie js z widoku akcji -->
<?php $view['slots']->output('javascript') ?>

<script>
    $(document).foundation();
</script>
</body>

</html>
