<?php
// Lista limitów rekordów na stronę. Można przekazać przy ładowaniu widoku.
$numItemsPerPage = $knp_pagination->getItemNumberPerPage();
$knp_steps = ! empty($knp_steps) ? $knp_steps : [100, 250, 500, 1000];
$per_page = intval($view['request']->getParameter('per_page')) ?: $numItemsPerPage;
$knp_params = $knp_pagination->getParams();

if (isset($knp_params['per_page'])) {
    unset($knp_params['per_page']);
}
?>

<form action="<?php echo $view['router']->path($knp_pagination->getRoute(), array_merge($knp_params, [])); ?>" method="get">
    <?php foreach ($knp_params as $param => $value): ?>
        <input type="hidden" name="<?php echo $param; ?>" value="<?php echo $value; ?>">
    <?php endforeach; ?>

    <select name="per_page">
        <?php foreach ($knp_steps as $step): ?>
            <option value="<?php echo $step; ?>" <?php echo $step == $per_page ? 'selected' : null; ?>><?php echo $step; ?> / <?php echo $view['translator']->trans('Table.perPage'); ?></option>
        <?php endforeach; ?>
    </select>
</form>
