<?php /* Sliding pagination control implementation in PHP Template */ ?>

<?php if ($pageCount > 0): ?>
    <ul class="pagination">
        <?php if (! empty($previous)): ?>
            <li class="pagination-previous">
                <a href="<?php echo $view['router']->path($route, array_merge($query, [$pageParameterName => $previous])); ?>"></a>
            </li>
        <?php endif; ?>

        <?php foreach ($pagesInRange as $page): ?>
            <?php if ($page != $current): ?>
                <li class="page">
                    <a href="<?php echo $view['router']->path($route, array_merge($query, [$pageParameterName => $page])); ?>"><?php echo $page; ?></a>
                </li>
            <?php else: ?>
                <li class="current"><?php echo $page; ?></li>
            <?php endif; ?>
        <?php endforeach; ?>

        <?php if (! empty($next)): ?>
            <li class="pagination-next">
                <a href="<?php echo $view['router']->path($route, array_merge($query, [$pageParameterName => $next])); ?>"></a>
            </li>
        <?php endif; ?>
    </ul>
<?php endif; ?>
