<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_users_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.users.Show')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/users.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>


<?php $view['slots']->start('breadcrumbs') ?>
    <li><?php echo $view['translator']->trans('main-menu.web_portal'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_users_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.users.List'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_users_show', ['id' => $user->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.users.Show'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('users.listTitle'); ?> - <?php echo $view['translator']->trans('usersShow.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-users color-menu-web-portal"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('usersShow.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <?php
    $userAvatar = ($user->getUserAvatars()->count() > 0) ? $user->getUserAvatars()->first() : null;
    $userInterested = ($user->getUserInterests()->count() > 0) ? $user->getUserInterests() : null;
    $profile = ($user->getProfile()->count() > 0) ? $user->getProfile()->first() : null;
    $billingData = ($user->getBillingData()->count() > 0) ? $user->getBillingData()->first() : null;
    ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configUserData-dropdown">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configUserData-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_USERS_EDIT')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_users_edit', array('id' => $user->getId())); ?>" class="" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span>
                                        <i class="icon-edit"></i>
                                        <?php echo $view['translator']->trans('Form.edit'); ?>
                                    </span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-th-list-outline"></i>
                <span><?php echo $view['translator']->trans('usersShow.listSubTitle'); ?> - <?php echo $user->getEmail(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <?php if ($view['session']->hasFlash('sendActivationMail.success')): ?>
                    <div class="callout success small">
                        <?php foreach ($view['session']->getFlash('sendActivationMail.success') as $message): ?>
                            <?php echo $message; ?>
                        <?php endforeach; ?>
                    </div>
                <?php endif ?>
                <div class="medium-6 large-3 columns">
                    <div class="avatarsImg">
                        <?php if (! is_null($userAvatar)): ?>
                            <img class="thumbnail" src="<?php echo $view['assets']->getUrl('media/avatars/'.$userAvatar->getAvatar()->getImage()); ?>" alt="<?php echo $user->getEmail(); ?>">
                        <?php endif; ?>
                    </div>
                    <?php if(! is_null($profile)): ?>
                        <?php echo $profile->getFirstName(); ?> <?php echo $profile->getLastName(); ?><br>
                        <?php if($profile->getDateOfBirth()): ?>
                            <?php echo $view['translator']->trans('usersEdit.form.dateOfBirth'); ?>:
                            <?php echo $profile->getDateOfBirth()->format('d.m.Y'); ?><br>
                        <?php endif; ?>
                        <?php echo $view['translator']->trans('usersEdit.form.pesel'); ?>: <?php echo $profile->getPesel(); ?><br>
                        <?php echo $view['translator']->trans('usersEdit.form.sex'); ?>: <?php echo ($profile->getSex()=='M' ? $view['translator']->trans('Male') : ($profile->getSex()=='F' ? $view['translator']->trans('Female') : '')); ?><br>

                    <?php endif; ?>
                    <b><?php echo $user->getEmail(); ?></b><br>
                        <?php echo $view['translator']->trans('usersList.table.Status'); ?>:
                        <?php if($user->getStatus()=='A'): ?>
                            <?php echo $view['translator']->trans('usersList.status.active'); ?>
                        <?php elseif ($user->getStatus()=='B'): ?>
                            <?php echo $view['translator']->trans('usersList.status.blocked'); ?>
                        <?php else: ?>
                            <?php echo $view['translator']->trans('usersList.status.notActive'); ?>
                        <?php endif; ?><br>
                    <?php if ($user->getStatus()!='A' && $view['config']->get('user.confirmEmail')): ?>
                        <a class="button tiny" href="<?php echo $view['router']->path('wi_admin_users_sendmail', ['id' => $user->getId()]); ?>"><?php echo $view['translator']->trans('usersList.sendActivationMail'); ?></a>
                    <?php endif; ?>
                </div>
                <div class="medium-6 large-3 columns">
                    <p class="titleBillingData"><?php echo $view['translator']->trans('usersShow.billingData'); ?></p>
                    <?php if(! is_null($billingData)): ?>
                    <p>
                        <?php echo $billingData->getName(); ?><br>
                        <?php echo $billingData->getAddress(); ?><br>
                        <?php echo $billingData->getZip(); ?> <?php echo $billingData->getCity(); ?><br>
                        <?php echo $billingData->getNIP(); ?><br>
                        <?php echo $billingData->getCountry(); ?>
                    </p>
                    <?php endif; ?>
                </div>
                <div class="medium-6 large-3 columns interestedUser">
                    <?php if(! is_null($userInterested)): ?>
                        <p class="titleBillingData"><?php echo $view['translator']->trans('usersShow.interested'); ?>:</p>
                        <ul class="no-bullet">
                            <?php foreach ($userInterested as $userInterest): ?>
                                <li><?php echo $userInterest->getInterest()->getName(); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                </div>
                <?php if(! is_null($profile)): ?>
                    <div class="medium-12 columns callout descUserShow">
                        <?php echo $profile->getDescription(); ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="row">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_users_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <?php if (count($favoriteNews) > 0): ?>
        <div class="box collapsed-box">
            <div class="box-header bg-transparent">
                <div class="pull-right box-tools">
                    <span><i class="icon-up-open" data-widget="collapse"></i></span>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-star-empty"></i> <span><?php echo $view['translator']->trans('usersShow.favorite.news.title'); ?></span></h3>
            </div>
            <div class="box-body" style="display: none;">
                <table>
                    <tbody>
                    <?php foreach ($favoriteNews as $fNews): ?>
                        <?php $image = $fNews->getImage(); ?>
                        <tr>
                            <td>
                                <div class="favorite-thumbnail <?php echo($image ? "nonebackground" : "opacity-50"); ?>">
                                <?php if ($image): ?>
                                    <img class="thumbnail" src="<?php echo $view['assets']->getUrl('media/assets/News/thumbnail/'.$image); ?>" alt="<?php echo $fNews->getTitle(); ?>">
                                <?php endif; ?>
                                </div>
                            </td>
                            <td><?php echo $fNews->getTitle(); ?></td>
                        </tr>
                    <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif ?>

    <?php if (count($favoritePosts) > 0): ?>
        <div class="box collapsed-box">
            <div class="box-header bg-transparent">
                <div class="pull-right box-tools">
                    <span><i class="icon-up-open" data-widget="collapse"></i></span>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-star-empty"></i> <span><?php echo $view['translator']->trans('usersShow.favorite.post.title'); ?></span></h3>
            </div>
            <div class="box-body" style="display: none;">
                <table>
                    <tbody>
                    <?php foreach ($favoritePosts as $fPost): ?>
                        <?php $image = $fPost->getImage(); ?>
                        <tr>
                            <td>
                                <div class="favorite-thumbnail <?php echo($image ? "nonebackground" : "opacity-50"); ?>">
                                <?php if ($image): ?>
                                    <img class="thumbnail" src="<?php echo $view['assets']->getUrl('media/assets/News/thumbnail/'.$image); ?>" alt="<?php echo $fPost->getTitle(); ?>">
                                <?php endif; ?>
                                </div>
                            </td>
                            <td><?php echo $fPost->getTitle(); ?></td>
                        </tr>
                    <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif ?>

    <div class="box <?php echo (($view['request']->getParameter('per_page') || $view['request']->getParameter('page') || $view['request']->getParameter('q')) ? '' : 'collapsed-box'); ?>">
        <!-- /.box-header -->
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <div class="pull-right box-tools">
            <span>
                <i class="icon-up-open" data-widget="collapse"></i>
            </span>
        </div>
        <h3 class="box-title" data-widget="collapse"><i class="icon-th-list-outline"></i>
            <span><?php echo $view['translator']->trans('usersShow.listSubTitleLog'); ?></span>
        </h3>
        <?php echo $view->render('KnpPaginatorBundle/Pagination/search.html.php', [
            'knp_pagination' => $logs,
        ]); ?>
    </div>
        <div class="box-body " style="display: <?php echo (($view['request']->getParameter('per_page') || $view['request']->getParameter('page') || $view['request']->getParameter('q')) ? 'block' : 'none'); ?>">
            <!-- User Logs -->
            <div class="row">
                <div class="columns tableResp">
                    <table id="logsTable">
                        <thead>
                        <tr>
                            <th><?php echo $view['knp_pagination']->sortable($logs, $view['translator']->trans('usersShow.tableLogs.id'), 'l.id'); ?></th>
                            <th><?php echo $view['translator']->trans('usersShow.tableLogs.type') ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($logs, $view['translator']->trans('usersShow.tableLogs.date'), 'l.datetime'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($logs, $view['translator']->trans('usersShow.tableLogs.name'), 'lt.name'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($logs as $log): ?>
                            <tr>
                                <td><?php echo $log->getId(); ?></td>
                                <td>
                                    <?php if($log->getLogType()->getType()=='I'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.info'); ?>
                                    <?php elseif ($log->getLogType()->getType()=='W'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.warning'); ?>
                                    <?php elseif ($log->getLogType()->getType()=='S'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.success'); ?>
                                    <?php elseif ($log->getLogType()->getType()=='E'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.error'); ?>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo $log->getDatetime()->format('Y-m-d H:i:s'); ?></td>
                                <td><?php echo $log->getLogType()->getName(); ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="medium-6 columns"></div>
                <div class="medium-6 columns paginationBox">
                    <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                        'knp_pagination' => $logs,
                    ]); ?>
                    <?php echo $view['knp_pagination']->render($logs); ?>
                </div>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
        var user = <?php echo $user->getId(); ?>;
    </script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/users.js') ?>"></script>
<?php $view['slots']->stop() ?>
