<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_users_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.users.Edit')) ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/users.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
<li><?php echo $view['translator']->trans('main-menu.web_portal'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_users_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.users.List'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_users_edit', ['id' => $user->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.users.Edit'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('users.listTitle'); ?> - <?php echo $view['translator']->trans('usersEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-users color-menu-web-portal"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('usersEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
            </div>
            <h3 class="box-title"><i class="icon-th-list-outline"></i>
                <span><?php echo $view['translator']->trans('usersEdit.changeProfileDataTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php echo $view['form']->start($profileForm); ?>
                <?php if ($view['form']->errors($profileForm)): ?>
                    <div class="alert callout small">
                        <?php echo $view['form']->errors($profileForm); ?>
                    </div>
                <?php endif; ?>
                <div class="row">
                    <div class="medium-6 columns">
                        <?php echo $view['form']->label($profileForm['firstName']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($profileForm['firstName']).'</div>' ?>
                        <?php echo ($view['form']->errors($profileForm['firstName']) ? $view['form']->widget($profileForm['firstName'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($profileForm['firstName'])) ?>
                    </div>
                    <div class="medium-6 columns">
                        <?php echo $view['form']->label($profileForm['lastName']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($profileForm['lastName']).'</div>' ?>
                        <?php echo ($view['form']->errors($profileForm['lastName']) ? $view['form']->widget($profileForm['lastName'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($profileForm['lastName'])) ?>
                    </div>
                </div>
                <div class="row">
                <div class="medium-6 columns">
                    <?php echo $view['form']->label($profileForm['sex']) ?>
                    <?php echo '<div class="formAlert">'.$view['form']->errors($profileForm['sex']).'</div>' ?>
                    <?php echo ($view['form']->errors($profileForm['sex']) ? $view['form']->widget($profileForm['sex'], array('attr' => array('class' =>'callout alert chosenSelect'))) : $view['form']->widget($profileForm['sex'])) ?>
                </div>
                <div class="medium-6 columns">
                    <?php echo $view['form']->label($profileForm['dateOfBirth']) ?>
                    <?php echo '<div class="formAlert">'.$view['form']->errors($profileForm['dateOfBirth']).'</div>' ?>
                    <?php echo ($view['form']->errors($profileForm['dateOfBirth']) ? $view['form']->widget($profileForm['dateOfBirth'], array('attr' => array('class' =>'callout alert datePicker'))) : $view['form']->widget($profileForm['dateOfBirth'])) ?>
                </div>
            </div>
            <div class="row">
                <div class="columns medium-6 end">
                    <?php echo $view['form']->label($profileForm['pesel']) ?>
                    <?php echo '<div class="formAlert">'.$view['form']->errors($profileForm['pesel']).'</div>' ?>
                    <?php echo ($view['form']->errors($profileForm['pesel']) ? $view['form']->widget($profileForm['pesel'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($profileForm['pesel'])) ?>
                </div>
            </div>
            <div class="row">
                <div class="columns">
                    <?php echo $view['form']->label($profileForm['description']) ?>
                    <?php echo '<div class="formAlert">'.$view['form']->errors($profileForm['description']).'</div>' ?>
                    <?php echo ($view['form']->errors($profileForm['description']) ? $view['form']->widget($profileForm['description'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($profileForm['description'], ['attr' => ['class' => 'tinyMCE']])) ?>
                </div>
            </div>
            <div class="row">
                <div class="columns">
                    <div class="wi-konatkt-form">
                        <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>"><i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.send'); ?></button>
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_users_show', array('id' => $user->getId())); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    </div>
                </div>
            </div>

            <?php echo $view['form']->widget($profileForm); ?>

            <?php echo $view['form']->end($profileForm); ?>
        </div>
    </div>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-credit-card"></i>
                <span><?php echo $view['translator']->trans('usersEdit.changeBillingDataTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php echo $view['form']->start($billingDataForm); ?>
                <?php if ($view['form']->errors($billingDataForm)): ?>
                    <div class="alert callout small">
                        <?php echo $view['form']->errors($billingDataForm); ?>
                    </div>
                <?php endif; ?>
                <div class="row">
                    <div class="columns medium-6">
                        <?php echo $view['form']->label($billingDataForm['name']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($billingDataForm['name']).'</div>' ?>
                        <?php echo ($view['form']->errors($billingDataForm['name']) ? $view['form']->widget($billingDataForm['name'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($billingDataForm['name'])) ?>
                    </div>
                    <div class="columns medium-6">
                        <?php echo $view['form']->label($billingDataForm['address']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($billingDataForm['address']).'</div>' ?>
                        <?php echo ($view['form']->errors($billingDataForm['address']) ? $view['form']->widget($billingDataForm['address'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($billingDataForm['address'])) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="medium-6 columns">
                        <?php echo $view['form']->label($billingDataForm['zip']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($billingDataForm['zip']).'</div>' ?>
                        <?php echo ($view['form']->errors($billingDataForm['zip']) ? $view['form']->widget($billingDataForm['zip'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($billingDataForm['zip'])) ?>
                    </div>
                    <div class="medium-6 columns">
                        <?php echo $view['form']->label($billingDataForm['city']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($billingDataForm['city']).'</div>' ?>
                        <?php echo ($view['form']->errors($billingDataForm['city']) ? $view['form']->widget($billingDataForm['city'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($billingDataForm['city'])) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="medium-6 columns">
                        <?php echo $view['form']->label($billingDataForm['country']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($billingDataForm['country']).'</div>' ?>
                        <?php echo ($view['form']->errors($billingDataForm['country']) ? $view['form']->widget($billingDataForm['country'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($billingDataForm['country'])) ?>
                    </div>
                    <div class="medium-6 columns">
                        <?php echo $view['form']->label($billingDataForm['NIP']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($billingDataForm['NIP']).'</div>' ?>
                        <?php echo ($view['form']->errors($billingDataForm['NIP']) ? $view['form']->widget($billingDataForm['NIP'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($billingDataForm['NIP'])) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="columns">
                        <div class="wi-konatkt-form">
                            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>"><i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.send'); ?></button>
                            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_users_show', array('id' => $user->getId())); ?>">
                                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                            </a>
                        </div>
                    </div>
                </div>
                <?php echo $view['form']->widget($billingDataForm); ?>
            <?php echo $view['form']->end($billingDataForm); ?>
        </div>
    </div>
    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-key-outline"></i>
                <span><?php echo $view['translator']->trans('usersEdit.changePassword'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <?php echo $view['form']->start($userForm); ?>
                <?php if ($view['form']->errors($userForm)): ?>
                    <div class="alert callout small">
                        <?php echo $view['form']->errors($userForm); ?>
                    </div>
                <?php endif; ?>
                <div class="row">
                    <div class="medium-6 columns">
                        <?php echo $view['form']->label($userForm['password']['first']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($userForm['password']['first']).'</div>' ?>
                        <?php echo ($view['form']->errors($userForm['password']['first']) ? $view['form']->widget($userForm['password']['first'], array('required' => false, 'attr' => array('class' =>'callout alert', 'novalidate' => 'novalidate'))) : $view['form']->widget($userForm['password']['first'], ['required' => false, 'attr' => ['novalidate' => 'novalidate']])) ?>


                    </div>
                    <div class="medium-6 columns">
                        <?php echo $view['form']->label($userForm['password']['second']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($userForm['password']['second']).'</div>' ?>
                        <?php echo ($view['form']->errors($userForm['password']['first']) ? $view['form']->widget($userForm['password']['second'], array('required' => false, 'attr' => array('class' =>'callout alert', 'novalidate' => 'novalidate'))) : $view['form']->widget($userForm['password']['second'], array('required' => false, 'attr' => array('novalidate' => 'novalidate')))) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="columns">
                        <div class="wi-konatkt-form">
                            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>"><i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.send'); ?></button>
                            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_users_show', array('id' => $user->getId())); ?>">
                                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                            </a>
                        </div>
                    </div>
                </div>
                <?php echo $view['form']->widget($userForm); ?>
            <?php echo $view['form']->end($userForm); ?>
        </div>
    </div>
    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span><i class="icon-up-open" data-widget="collapse"></i></span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-mail"></i><span><?php echo $view['translator']->trans('usersEdit.changeAllowNewsletter'); ?></span></h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <?php echo $view['form']->start($userNewsletterForm); ?>
                <div class="row">
                    <div class="medium-4 columns">
                        <p><?php echo $view['translator']->trans('usersEdit.changeAllowNewsletterInfo'); ?></p>
                    </div>
                    <div class="medium-8 columns">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($userNewsletterForm['allowNewsletter']); ?>
                        </div>
                        <div>
                            <?php echo $view['form']->widget($userNewsletterForm['allowNewsletter']); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="columns">
                        <div class="wi-konatkt-form">
                            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>"><i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.send'); ?></button>
                            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_users_show', array('id' => $user->getId())); ?>">
                                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            <?php echo $view['form']->end($userNewsletterForm); ?>
        </div>
    </div>
    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-user-times"></i>
                <span><?php echo $view['translator']->trans('usersEdit.changeStatus'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <?php echo $view['form']->start($userStatusForm); ?>
                <div class="row">
                    <div class="medium-4 columns">
                        <p><?php echo $view['translator']->trans('usersEdit.changeStatusInfo'); ?></p>
                    </div>
                    <div class="medium-8 columns">
                        <?php if ($view['form']->errors($userStatusForm)): ?>
                            <div class="alert callout small">
                                <?php echo $view['form']->errors($userStatusForm); ?>
                            </div>
                        <?php endif; ?>
                        <?php echo $view['form']->label($userStatusForm['status']) ?>
                        <?php echo '<div class="formAlert">'.$view['form']->errors($userStatusForm['status']).'</div>' ?>
                        <?php echo ($view['form']->errors($userStatusForm['status']) ? $view['form']->widget($userStatusForm['status'], array('attr' => array('class' =>'callout alert chosenSelect'))) : $view['form']->widget($userStatusForm['status'])) ?>
                        <?php echo $view['form']->widget($userStatusForm); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="columns">
                        <div class="wi-konatkt-form">
                            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>"><i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.send'); ?></button>
                            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_users_show', array('id' => $user->getId())); ?>">
                                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            <?php echo $view['form']->end($userStatusForm); ?>
        </div>
    </div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/users.js') ?>"></script>
<?php $view['slots']->stop() ?>
