<table class="table-seo">
    <thead>
        <tr>
            <th><?php echo $view['translator']->trans('seo.table.id', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.title', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.type', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.image', [], 'seo'); ?></th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($pages as $page): ?>
        <?php $og = $view['seo']->getOgArray($page); ?>
        <tr>
            <td><?php echo $page->getId(); ?>.</td>
            <td class="edit-hover">
                <?php echo $page->getTitle(); ?>
                <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                <a href="<?php echo $view['router']->path('wi_admin_pages_edit', ['id' => $page->getId()]); ?>" class="edit-button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                    <span><i class="icon-edit"></i></span>
                </a>
                <?php endif ?>
            </td>
            <td><span class="generate-type type-<?php echo $og['og_type']['type']; ?>"><?php echo $og['og_type']['value']; ?></span></td>
            <td>
                <?php if (! is_null($og['og_image']['value'])): ?>
                    <img src="<?php echo $og['og_image']['value']; ?>" alt="" class="seo-og-image"><br>
                    <span class="og-link-small"><?php echo $og['og_image']['value']; ?></span>
                <?php else: ?>
                    <span class="generate-type type-<?php echo $og['og_image']['type']; ?>">
                        <?php echo $view['translator']->trans('no'); ?>
                    </span>
                <?php endif; ?>
            </td>
        </tr>
    <?php endforeach ?>
    </tbody>
</table>
