<table class="table-seo">
    <thead>
        <tr>
            <th><?php echo $view['translator']->trans('seo.table.id', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.title', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.type', [], 'seo'); ?></th>
            <th><?php echo $view['translator']->trans('seo.table.image', [], 'seo'); ?></th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($forms as $form): ?>
        <?php $og = $view['seo']->getOgArray($form); ?>
        <tr>
            <td>
                <?php echo $form->getId(); ?>.
            </td>
            <td class="edit-hover">
                <?php echo $form->getName(); ?>
                <?php if ($view['security']->isGranted('ROLE_CONTACT_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('wi_admin_contact_edit', ['id' => $form->getId()]); ?>" class="edit-button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                        <span><i class="icon-edit"></i></span>
                    </a>
                <?php endif ?>
            </td>
            <td><span class="generate-type type-<?php echo $og['og_type']['type']; ?>"><?php echo $og['og_type']['value']; ?></span></td>
            <td>
                <?php if (! is_null($og['og_image']['value'])): ?>
                    <img src="<?php echo $og['og_image']['value']; ?>" alt="" class="seo-og-image"><br>
                    <span class="og-link-small"><?php echo $og['og_image']['value']; ?></span>
                <?php else: ?>
                    <span class="generate-type type-<?php echo $og['og_image']['type']; ?>">
                        <?php echo $view['translator']->trans('no'); ?>
                    </span>
                <?php endif; ?>
            </td>
        </tr>
    <?php endforeach ?>
    </tbody>
</table>
