<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.sender.senderEdit')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_edit', ['id' => $sender->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.sender.senderEdit'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('sender.listTitle'); ?> - <?php echo $view['translator']->trans('sender.subTitleEdit'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-mail"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('sender.edit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>

<?php echo $view['form']->start($form, array('multipart' => true, 'attr' => array( 'id' => 'wi_admin_newsletterbundle_senders' ))); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowNews-dropdown">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowNews-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_delete', ['id' => $sender->getId()]); ?>">
                                    <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('sender.show.remove'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('sender.edit.boxTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sender.edit.email'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('sender.edit.emailDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['email']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['email']) ? $view['form']->widget($form['email'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['email'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sender.edit.name'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('sender.edit.nameDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['name']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['name']) ? $view['form']->widget($form['name'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['name'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sender.edit.replayTo'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('sender.edit.replayToDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-3 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['replayTo']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['replayTo']) ? $view['form']->widget($form['replayTo'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['replayTo'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sender.edit.smtpLogin'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('sender.edit.smtpLoginDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-3 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['smtpLogin']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['smtpLogin']) ? $view['form']->widget($form['smtpLogin'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['smtpLogin'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sender.edit.smtpPassword'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('sender.edit.smtpPasswordDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-3 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['smtpPassword']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['smtpPassword']) ? $view['form']->widget($form['smtpPassword'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['smtpPassword'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sender.edit.smtpHost'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('sender.edit.smtpHostDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-3 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['smtpHost']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['smtpHost']) ? $view['form']->widget($form['smtpHost'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['smtpHost'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sender.edit.smtpSSL'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('sender.edit.smtpSSLDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-3 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['smtpSsl']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['smtpSsl']) ? $view['form']->widget($form['smtpSsl'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['smtpSsl'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sender.edit.smtpPort'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('sender.edit.smtpPortDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-3 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['smtpPort']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['smtpPort']) ? $view['form']->widget($form['smtpPort'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['smtpPort'])); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <?php echo $view['form']->widget($form); ?>
            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_senders_show', ['id' => $sender->getId()]); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
            </a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>

<?php $view['slots']->stop() ?>


<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
