<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta name="robots" content="noindex, nofollow">
    <link rel="shortcut icon" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/WiCMS-favicon.png') ?>" />
    <title><?php echo $view['translator']->trans('forgot.title'); ?></title>
    <link rel="stylesheet"
          href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Foundation/foundation-sites/dist/css/foundation-float.min.css') ?>"/>
    <link rel="stylesheet"
          href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/css/Montserrat-Hairline.css') ?>"/>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/login.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">

</head>

<body>

<!-- right sidebar wrapper -->
<div class="inner-wrap">
    <div class="wrap-fluid">
        <div class="row columns">
            <div class="profile">
                <img alt="" class="" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/WiCMS-logo-white-200px.png') ?>">
            </div>
        </div>
        <div class="loginWhite">
            <div class="row">
                <div class="columns text-center">
                    <h1><?php echo $view['translator']->trans('login.nameWiCMS'); ?></h1>
                    <p class="text-center"><?php echo $view['translator']->trans('login.infoWiCMS'); ?></p>
                    <hr>
                </div>
            </div>
            <div class="row">
                <div class="columns text-center formLogin">

                    <h3><?php echo $view['translator']->trans('forgot.header'); ?></h3>
                    <div class="box bg-white float-center">
                        <!-- Profile -->
                        <!-- End of Profile -->
                        <!-- /.box-header -->
                        <div class="box-body " style="display: block;">
                            <div class="row">
                                <div class="large-12 columns">
                                    <div class="row">
                                        <div class="edumix-signup-panel">
                                            <p class="welcome"></p>


                                            <?php echo $view['form']->start($formForgot); ?>
                                            <?php if ($view['form']->errors($formForgot)): ?>
                                                <div class="alert callout small"><?php echo $view['form']->errors($formForgot); ?></div>
                                            <?php endif ?>

                                            <?php if ($view['session']->hasFlash('forgot.error')): ?>
                                                <div class="alert callout small">
                                                    <?php foreach ($view['session']->getFlash('forgot.error') as $message): ?>
                                                        <?php echo $message; ?>
                                                    <?php endforeach; ?>
                                                </div>
                                            <?php endif ?>
                                            <?php if ($view['session']->hasFlash('forgot.success')): ?>
                                                <div class="success callout small">
                                                    <?php foreach ($view['session']->getFlash('forgot.success') as $message): ?>
                                                        <?php echo $message; ?>
                                                    <?php endforeach; ?>
                                                </div>
                                            <?php else: ?>
                                                <div class="row column log-in-form forgot-pass">
                                                    <?php echo $view['form']->label($formForgot['email']); ?>
                                                    <?php echo $view['form']->errors($formForgot['email']); ?>
                                                    <?php echo $view['form']->widget($formForgot['email']); ?>
                                                    <p>
                                                        <input type="submit" class="button float-center"
                                                               value="<?php echo $view['translator']->trans('forgot.button'); ?>">
                                                    </p>
                                                </div>
                                                <?php echo $view['form']->end($formForgot); ?>
                                            <?php endif ?>
                                            <br>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <!-- end .timeline -->
                    </div>
                    <!-- box -->
                </div>
            </div>
            <!-- Container Begin -->

        </div>
        <footer>
            <div class="row">
                <div class="medium-6 columns profile-dol">
                    <a href="http://www.webimpuls.pl" title="<?php echo $view['translator']->trans('footer.wi-link-title'); ?>" class="">
                        <img class="webimpulsLogo" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/WEBimpuls-logo-2015-500px.png') ?>" alt="<?php echo $view['translator']->trans('footer.wi-img-alt'); ?>">
                    </a><br>
                    <a href="http://www.webimpuls.pl" title="<?php echo $view['translator']->trans('footer.wi-link-title'); ?>" class="webimpuls"><?php echo $view['translator']->trans('footer.Copyright'); ?></a>
                    <p><?php echo $view['translator']->trans('footer.CopyrightInfo'); ?></p>
                </div>
                <div class="medium-6 columns profile-dol-right">
                    <h4><?php echo $view['translator']->trans('login.moreInfo'); ?></h4>
                    <ul>
                        <li>
                            <a href="http://www.webimpuls.pl" title="<?php echo $view['translator']->trans('footer.wi-link-title'); ?>"><span><?php echo $view['translator']->trans('login.wi-link'); ?></span></a>
                        </li>
                        <li>
                            <a href="http://www.wicms.pl" title="<?php echo $view['translator']->trans('login.wi-link-wicms'); ?>"><span><?php echo $view['translator']->trans('login.wi-link-wi'); ?></span></a>
                        </li>
                    </ul>
                    <ul>
                        <li>
                            <a title="<?php echo $view['translator']->trans('login.wi-link-help'); ?>"><span><?php echo $view['translator']->trans('login.wi-link-help'); ?></span></a>
                        </li>
                    </ul>
                    <a href="<?php echo $view['router']->path('homepage') ?>" class="button">
                        <?php echo $view['translator']->trans('login.showPage'); ?>
                    </a>
                </div>
            </div>
        </footer>
    </div>
    <!-- End of Container Begin -->
</div>


</body>

</html>
