<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.recipient.recipientList')) ?>

<?php $view['slots']->start('stylesheets') ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.recipient.recipientList'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
<i class="icon-mail"></i> Recipient group - New
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
Recipient group new. Create new recipient group.
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<?php echo $view['form']->start($form, array('multipart' => true, 'attr' => array( 'id' => 'wi_admin_newsletterbundle_recipients' ))); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('recipient.new.boxTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('recipient.new.name'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="Name of the recipient group"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['name']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['name']) ? $view['form']->widget($form['name'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['name'])); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <?php echo $view['form']->widget($form); ?>
            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
            </button>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_index', ['_fragment' => 'recipient-groups']); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
            </a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
<script>
    var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
</script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
