<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_faq_question_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.faqQuestion.questionEdit')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/faq.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li><a href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.faq'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_faq_question_edit', array('id' => $question->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.questionEdit'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('faqQuestion.listSubTitle'); ?> - <?php echo $view['translator']->trans('faqQuestionEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-help-circled-1 color-menu-content"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('faqQuestionEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-edit"></i> <span><?php echo $view['translator']->trans('faqQuestionEdit.boxTitle'); ?> - <?php echo $question->getQuestion(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php echo $view['form']->start($form, array('multipart' => true, 'attr' => array('id' => 'questionNew'))); ?>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('faqQuestionEdit.form.titleTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('faqQuestionEdit.form.titleDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['question']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['question']) ? $view['form']->widget($form['question'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['question'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('faqQuestionEdit.form.shortTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('faqQuestionEdit.form.shortDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="question-add-form">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['shortcut']); ?>
                        </div>
                        <?php echo ($view['form']->errors($form['shortcut']) ? $view['form']->widget($form['shortcut'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['shortcut'])); ?>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('faqQuestionEdit.form.textTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('faqQuestionEdit.form.textDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="question-add-form">
                        <div class="formAlert <?php echo ($view['form']->errors($form['answer']) ? "callout alert" : ""); ?>">
                            <?php echo $view['form']->errors($form['answer']); ?>
                        </div>
                        <div class="formAlert callout alert" id="contentValidation">
                            <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                        </div>
                        <?php echo $view['form']->widget($form['answer']); ?>
                    </div>
                </div>
            </div>
            <hr>
        </div>
    </div>
    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('faqQuestionEdit.box2Title'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('faqQuestionEdit.form.catTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('faqQuestionEdit.form.catDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="question-add-form">
                        <?php echo ($view['form']->errors($form['categories']) ? $view['form']->widget($form['categories'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['categories'])); ?>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('faqQuestionEdit.form.dateTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('faqQuestionEdit.form.dateDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="question-add-form">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['dateOfPublication']); ?>
                        </div>
                        <?php echo ($view['form']->errors($form['dateOfPublication']) ? $view['form']->widget($form['dateOfPublication'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['dateOfPublication'])); ?>
                    </div>
                </div>
            </div>
            <hr>
        </div>
    </div>
    <div class="box metaTags collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('newsEdit.metaTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('faqQuestionEdit.form.metaTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('faqQuestionEdit.form.metaDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaTitle']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaTitle']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaTitle']) ? $view['form']->widget($form['metaTitle'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaTitle'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaDescription']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaDescription']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaDescription']) ? $view['form']->widget($form['metaDescription'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaDescription'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaCanonical']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaCanonical']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaCanonical']) ? $view['form']->widget($form['metaCanonical'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaCanonical'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="row">
    <div class=" columns">
        <div class="question-add-form">
            <?php echo $view['form']->widget($form); ?>
            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
            <?php echo $view['form']->end($form); ?>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_faq_question_show', array('id' => $question->getId())); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
            </a>
        </div>
    </div>
</div>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js') ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.js') ?>"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/faq.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
