<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_galleries_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.galleries.photo.edit')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/galleries.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.content'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_galleries_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.galleries.photo.edit'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite') ?>
<?php echo $view['translator']->trans('galleries.gallery.index.title'); ?> - <?php echo $view['translator']->trans('galleries.photo.edit.subtitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-camera-1 color-menu-content"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
<?php echo $view['translator']->trans('galleries.photo.edit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>


<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-picture"></i><span><?php echo $view['translator']->trans('galleries.photo.edit.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns large-2"></div>
            <div class="columns large-10">
                <img src="<?php echo $view['assets']->getUrl($photo->getPhoto('thumbnail')); ?>">
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="columns large-2">
                <p><strong><?php echo $view['translator']->trans('galleries.photo.form.title.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('galleries.photo.form.title.desc'); ?>"></i>
                </p>
            </div>
            <div class="columns large-10">
                <div class="medium-6">
                    <div class="formAlert"><?php echo $view['form']->errors($form['title']); ?></div>
                    <?php echo $view['form']->widget($form['title'], [
                        'attr' => [
                            'class' => ($form['title']->vars['attr']['class'] ?? '') . (! $form['title']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="columns large-2">
                <p><strong><?php echo $view['translator']->trans('galleries.photo.form.content.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('galleries.photo.form.content.desc'); ?>"></i>
                </p>
            </div>
            <div class="columns large-10">
                <div class="formAlert"><?php echo $view['form']->errors($form['content']); ?></div>
                <?php echo $view['form']->widget($form['content'], [
                    'attr' => [
                        'class' => ($form['content']->vars['attr']['class'] ?? '') . (! $form['content']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.edit'); ?>">
            <i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.edit'); ?>
        </button>
        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_galleries_index', ['id' => $gallery->getId()]); ?>">
            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
        </a>
    </div>
</div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script>
    var language = '<?php echo $view['request']->getLocale(); ?>';
</script>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinymce-basic.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/galleries.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
