<?php
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
?>
<div class="<?php echo $boxListClass ?: 'box-list-first'; ?>">
    <div class="box boxPagesGroup <?php echo ($pageGroup->getId() == 1 && is_null($view['request']->getParameter('q'))) ? 'collapsed-box' : ''; ?>">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT') && $pageGroup->getId() != 1): ?>
                    <a href="<?php echo $view['router']->path('wi_admin_pages_new', ['page_group_id' => $pageGroup->getId()]); ?>" title="<?php echo $translator->trans('page.index.add_page_in_group', [], 'page'); ?>" class="button tiny primary buttonAddNew"><i class="icon-doc-add"></i><?php echo $translator->trans('page.index.add_page_in_group', [], 'page'); ?></a>
                <?php endif; ?>
                <span class="box-btn" data-toggle="configPagesGroup<?php echo $pageGroup->getId(); ?>-dropdown"><i class="icon-ellipsis-vert"></i></span>
                <div id="configPagesGroup<?php echo $pageGroup->getId(); ?>-dropdown" class="dropdown-pane configBoxButtons" data-alignment="center" data-close-on-click="true" data-dropdown data-position="bottom">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT') && $pageGroup->getId() != 1): ?>
                        <li><a href="<?php echo $view['router']->path('wi_admin_pages_new', ['page_group_id' => $pageGroup->getId()]); ?>" title="<?php echo $translator->trans('page.index.add_page_in_group', [], 'page'); ?>"><span><i class="icon-doc-add"></i><?php echo $translator->trans('page.index.add_page_in_group', [], 'page'); ?></span></a></li>
                        <?php endif; ?>
                        <li><a href="<?php echo $view['router']->path('wi_admin_page_groups_show', ['id' => $pageGroup->getId()]); ?>" title="<?php echo $translator->trans('page.index.show_group', [], 'page'); ?>"><span><i class="icon-folder-2"></i><?php echo $translator->trans('page.index.show_group', [], 'page'); ?></span></a></li>
                        <li class="odciecie">
                            <button type="button" class="collapseAll"><span><i class="icon-collapse"></i> <?php echo $translator->trans('page.index.collapse', [], 'page'); ?></span></button>
                            | <button type="button" class="expandAll"><span><i class="icon-expand"></i> <?php echo $translator->trans('page.index.expand', [], 'page'); ?></span></button>
                        </li>
                    </ul>
                </div>
                <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-folder"></i><span><?php echo $prefix.$pageGroup->getName(); ?></span></h3>
            <input type="text" class="searchThisGroup" data-table="pagesGroupTable<?php echo $key; ?>" placeholder="<?php echo $translator->trans('page.index.search_in_group', [], 'page'); ?>">
        </div>
        <div class="box-body" style="display: <?php echo ($pageGroup->getId() == 1 && is_null($view['request']->getParameter('q'))) ? 'none' : 'block'; ?>">
            <?php if ($pageGroup->getPages()->count() > 0): ?>
            <div class="row">
                <div class="columns tableResp">
                    <table class="hover pagesGroupTable<?php echo $key; ?> pagesGroupTable">
                        <thead>
                            <tr>
                                <th><?php echo $translator->trans('page.table.id', [], 'page'); ?></th>
                                <th><?php echo $translator->trans('page.table.title', [], 'page'); ?></th>
                                <th><?php echo $translator->trans('page.table.shortcut', [], 'page'); ?></th>
                                <th><?php echo $translator->trans('page.table.date_created', [], 'page'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php /** @var \Admin\WicmsBundle\Entity\Page $page */
                        foreach ($pageGroup->getPages() as $page): ?>
                            <tr>
                                <td><?php echo $page->getId(); ?></td>
                                <td>
                                    <a href="<?php echo $view['router']->path('wi_admin_pages_show', ['id' => $page->getid()]); ?>" title="<?php echo $translator->trans('Table.showButton'); ?>"><b><?php echo $page->getTitle(); ?></b></a>
                                    <div class="buttonItemsBox">
                                        <div class="buttonsItems">
                                            <a href="<?php echo $view['router']->path('wi_admin_pages_show', ['id' => $page->getId()]); ?>"><i class="icon-eye-1"></i><?php echo $translator->trans('Table.showButton'); ?></a>
                                            <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                                            | <a href="<?php echo $view['router']->path('wi_admin_pages_edit', ['id' => $page->getId()]); ?>"><i class="icon-edit-1"></i><?php echo $translator->trans('Table.editButton'); ?></a>
                                            | <a href="<?php echo $view['router']->path('wi_admin_pages_delete', ['id' => $page->getId()]); ?>"><i class="icon-cancel-circled-outline"></i><?php echo $translator->trans('Table.deleteButton'); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td><?php echo $page->getShortContent(); ?></td>
                                <td><?php echo $page->getDateCreated()->format('d.m.Y'); ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <?php
    // Jeśli są podgrupy.
    if ($pageGroup->getChildren()->count()) {
        echo $displayPageGroupsWithPages($pageGroup->getChildren(), $prefix . $pageGroup->getName() . ' > ', 'box-list');
    }
    ?>
</div>
