<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_offer_offer_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.offers.offer.edit')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.modules_addons'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_offer_offer_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.offers.offer.index'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_offer_offer_edit', ['id' => $offer->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.offers.offer.edit'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('offers.offer.index.title'); ?> - <?php echo $view['translator']->trans('offers.offer.index.subtitle'); ?> - <?php echo $view['translator']->trans('offers.offer.edit.subtitle'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-megaphone color-menu-web-portal"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('offers.offer.edit.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form) ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-megaphone"></i><span><?php echo $view['translator']->trans('offers.offer.edit.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('offers.offer.form.content.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('offers.offer.form.content.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['content']); ?></div>
                <?php echo $view['form']->widget($form['content'], [
                    'attr' => [
                        'class' => ($form['content']->vars['attr']['class'] ?? '') . (! $form['content']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('offers.offer.form.user.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('offers.offer.form.user.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="formAlert"><?php echo $view['form']->errors($form['user']); ?></div>
                        <?php echo $view['form']->widget($form['user'], [
                            'attr' => [
                                'class' => ($form['user']->vars['attr']['class'] ?? '') . (! $form['user']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('offers.offer.form.price.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('offers.offer.form.price.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="formAlert"><?php echo $view['form']->errors($form['price']); ?></div>
                        <?php echo $view['form']->widget($form['price'], [
                            'attr' => [
                                'class' => ($form['price']->vars['attr']['class'] ?? '') . (! $form['price']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('offers.offer.form.city.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('offers.offer.form.city.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="formAlert"><?php echo $view['form']->errors($form['city']); ?></div>
                        <?php echo $view['form']->widget($form['city'], [
                            'attr' => [
                                'class' => ($form['city']->vars['attr']['class'] ?? '') . (! $form['city']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('offers.offer.form.voivodeship.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('offers.offer.form.voivodeship.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="formAlert"><?php echo $view['form']->errors($form['voivodeship']); ?></div>
                        <?php echo $view['form']->widget($form['voivodeship'], [
                            'attr' => [
                                'class' => ($form['voivodeship']->vars['attr']['class'] ?? '') . (! $form['voivodeship']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('offers.offer.form.dateExpired.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('offers.offer.form.dateExpired.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="formAlert"><?php echo $view['form']->errors($form['dateExpired']); ?></div>
                        <?php echo $view['form']->widget($form['dateExpired'], [
                            'attr' => [
                                'class' => ($form['dateExpired']->vars['attr']['class'] ?? '') . (! $form['dateExpired']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('offers.offer.form.categories.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('offers.offer.form.categories.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="formAlert"><?php echo $view['form']->errors($form['categories']); ?></div>
                        <?php echo $view['form']->widget($form['categories'], [
                            'attr' => [
                                'class' => ($form['categories']->vars['attr']['class'] ?? '') . (! $form['categories']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('offers.offer.form.contractor.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('offers.offer.form.contractor.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="formAlert"><?php echo $view['form']->errors($form['contractor']); ?></div>
                        <?php echo $view['form']->widget($form['contractor'], [
                            'attr' => [
                                'class' => ($form['contractor']->vars['attr']['class'] ?? '') . (! $form['contractor']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.save_publish'); ?>">
                <i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.save_publish'); ?>
            </button>
            <?php echo $view['form']->widget($form['save_draft']); ?>

            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_offer_offer_index'); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
            </a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form) ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/offer.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>
