<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_menu_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.menu.Edit')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/menu.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.template_extension'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_menu_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.menu.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_menu_edit', ['id' => $itemMenu->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.menu.Edit'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('menu.listTitle'); ?> -
    <?php echo $view['translator']->trans('menuEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-th-list-2 color-menu-template-extension"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('menuEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <?php echo $view['form']->start($form, ['attr' => ['class' => 'formNewItemMenu']]); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configMenuEdit-dropdown">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configMenuEdit-dropdown" data-dropdown  data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <a class="" href="<?php echo $view['router']->path('wi_admin_menu_delete', ['id' => $itemMenu->getId()]); ?>">
                                <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('menuEdit.deleteButton'); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title">
                <i class="icon-list-numbered-1"></i>
                <span>
                    <?php echo $view['translator']->trans('menuEdit.boxTitle'); ?> - <?php echo $itemMenu->getName(); ?>
                </span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('menuNew.name.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('menuNew.name.titleDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns medium-6 end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['name']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['name']) ? $view['form']->widget($form['name'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['name'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('menuNew.link.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('menuNew.link.titleDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="url">
                        <div class="row">
                            <div class="medium-6 columns">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['url']); ?>
                                </div>
                                <div class="formAlertVal alert callout small urlValText"><?php echo $view['translator']->trans('menuNew.val'); ?></div>
                                <?php echo ($view['form']->errors($form['url']) ? $view['form']->widget($form['location'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['url'])); ?>
                            </div>
                            <div class="medium-6 columns end">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['external']); ?>
                                </div>
                                <div class="externalLabel">
                                <?php echo $view['form']->label($form['external']); ?>
                                </div>
                                <div class="externalLabel">
                                <?php echo ($view['form']->errors($form['external']) ? $view['form']->widget($form['location'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['external'])); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="box collapsed-box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <div class="pull-right box-tools">
            <span>
                <i class="icon-up-open" data-widget="collapse"></i>
            </span>
        </div>
        <h3 class="box-title" data-widget="collapse">
            <i class="icon-list-numbered-1"></i> <span><?php echo $view['translator']->trans('menuNew.boxTitleAdvanced'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: none;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('menuNew.options.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('menuNew.options.titleDesc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="columns medium-6">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['title']); ?>
                        </div>
                        <?php echo $view['form']->label($form['title']); ?>
                        <?php echo ($view['form']->errors($form['title']) ? $view['form']->widget($form['name'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['title'])); ?>
                    </div>
                    <div class="large-2 medium-4 small-6 columns end">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['orderNr']); ?>
                        </div>
                        <?php echo $view['form']->label($form['orderNr']); ?>
                        <?php echo ($view['form']->errors($form['orderNr']) ? $view['form']->widget($form['location'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['orderNr'])); ?>
                    </div>
                    <div class="columns medium-6">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['status']); ?>
                        </div>
                        <?php echo $view['form']->label($form['status']); ?>
                        <?php echo $view['form']->widget($form['status']); ?>
                    </div>
                    <div class="columns medium-6">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['parent']); ?>
                        </div>
                        <?php echo $view['form']->label($form['parent']); ?>
                        <?php echo $view['form']->widget($form['parent']); ?>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('menuNew.location.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('menuNew.location.titleDesc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="columns medium-6 end">
                        <div class="formAlert">
                            <?php echo $view['form']->errors($form['location']); ?>
                        </div>
                        <?php echo $view['form']->widget($form['location']); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <?php echo $view['form']->widget($form); ?>
        <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
            <i class="icon-edit"></i>
            <?php echo $view['translator']->trans('Form.send'); ?>
        </button>

        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_menu_index'); ?>">
            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
        </a>
    </div>
</div>
    <?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/menu.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
