<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_menu_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.menu.Delete')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/menu.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.template_extension'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_menu_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.menu.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_menu_delete', ['id' => $itemMenu->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.menu.Delete'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('menu.listTitle'); ?> -
    <?php echo $view['translator']->trans('menuDelete.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-th-list-2 color-menu-template-extension"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('menuDelete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php // Funkcja wyświetlająca dzieci pozycji ?>
<?php function getChildrenView($items) { ?>
    <ul class="childrenView">
        <?php foreach ($items as $item): ?>
            <li>
                <?php echo $item->getName(); ?>
                <?php getChildrenView($item->getChildren()); ?>
            </li>
        <?php endforeach; ?>
    </ul>
<?php } ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-folder-delete"></i>
                <span><?php echo $view['translator']->trans('menuDelete.listSubTitle'); ?> - <?php echo $itemMenu->getName() ?> </span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php echo $view['form']->start($formDelete, ['attr' => ['class' => 'deleteMenuItemForm']]); ?>
            <p class="itemDeleteQuestion"><?php echo $view['translator']->trans('menuDelete.confirm'); ?></p>
            <div class="switch-admin">
                <?php echo $view['form']->errors($formDelete['deleteItemMenu']); ?>
                <?php echo $view['form']->widget($formDelete['deleteItemMenu']); ?>
            </div>
            <span id="countChildren"  wartosc="<?php echo $itemMenu->getChildren()->count() ?>"></span>
            <div class="confirmDelete" id="confirmDelete">
                <?php if($itemMenu->getChildren()->count()): ?>
                    <p class="itemDeleteQuestion"><?php echo $view['translator']->trans('menuDelete.listChildren') ?>:</p>
                    <?php getChildrenView($itemMenu->getChildren()); ?>
                    <p class="itemDeleteQuestion"><?php echo $view['translator']->trans('menuDelete.confirmChildren'); ?></p>
                    <div class="switch-admin">
                        <?php echo $view['form']->errors($formDelete['deleteAll']); ?>
                        <?php echo $view['form']->widget($formDelete['deleteAll']); ?>
                        <label class="switch-paddle" for="<?php echo $formDelete->children['deleteAll']->vars['id']; ?>">
                            <span class="show-for-sr"><?php echo $view['translator']->trans('menuDelete.confirmChildren'); ?></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                    <div class="confirmDeleteItemMenu" id="confirmDeleteItemMenu">
                        <div class="selectParent" id="selectParent">
                            <p class="itemDeleteQuestion"><?php echo $view['translator']->trans('menuDelete.changeParents'); ?></p>
                            <div class="newItemSelect">
                                <?php echo $view['form']->errors($formDelete['newItemMenu']); ?>
                                <?php echo $view['form']->widget($formDelete['newItemMenu']); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php echo $view['form']->widget($formDelete); ?>
                <button type="submit" id="itemMenuDeleteInput" class="button alert tiny itemMenuDeleteInput" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                    <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                </button>
            </div>
            <?php echo $view['form']->end($formDelete); ?>
            <div class="row navigationBottom">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_menu_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop() ?>


<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/menu.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
