<?php
/** @var \Admin\WicmsBundle\Templating\Helper\MediaHelper $mediaHelper */
$mediaHelper = $view['media'];
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\RequestHelper $requestHelper */
$requestHelper = $view['request'];
?>

<div class="album-navigation-wrapper">
    <span class="you-are-here"><?php echo $translator->trans('media.navigation.you_are_here', [], 'media'); ?>:</span>
    <a data-url class="back folder"><?php echo $translator->trans('media.navigation.main_folder', [], 'media'); ?>/</a><?php if ($directory = $requestHelper->getParameter('directory')): ?><?php $path = ''; ?><?php foreach (array_filter(explode('/', $directory)) as $folder): ?><?php $path .= $folder.'/'; ?><a data-url="<?php echo rtrim($path, '/'); ?>" class="back folder"><?php echo $folder; ?>/</a><?php endforeach; ?><?php endif; ?>
</div>
<p class="clearfix">
    <?php if ($mediaHelper->displayBackLink($currentDirectory)): ?>
        <a data-url="<?php echo $previousDirectory; ?>" class="back button secondary tiny"><i class="icon-reply"></i> <?php echo $translator->trans('media.navigation.back', [], 'media'); ?></a>
    <?php endif; ?>
    <?php if ($mediaHelper->isNonReadonlyDirectory($requestHelper->getParameter('directory'), '') && $view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
        <a class="button tiny" id="media-button"><i class="icon-upload"></i><?php echo $translator->trans('media.navigation.add_files', [], 'media'); ?></a>
        <a class="button tiny" data-open="addFolder"><i class="icon-folder-add"></i> <?php echo $translator->trans('media.navigation.add_directory', [], 'media'); ?></a>
    <?php endif; ?>
    <span class="float-right">
    <span class="button tiny secondary media-view" data-view="grid"><i class="icon-th"></i></span>
    <span class="button tiny secondary media-view" data-view="list"><i class="icon-th-list"></i></span>
</span>
</p>
<div class="media gallery-wrapper<?php echo ($mediaHelper->isNonReadonlyDirectory($requestHelper->getParameter('directory'), '') && $view['security']->isGranted('ROLE_MEDIA_EDIT')) ? ' media-drop-area' : ''; ?>" id="media-drop-area" data-directory="<?php echo $requestHelper->getParameter('directory'); ?>">
    <div class="gallery-main-wrapper without-info" id="gallery-main">
        <?php if (! empty($directories)): ?>
            <h6><?php echo $translator->trans('media.items.directories', [], 'media'); ?></h6>
            <div class="items">
                <?php
                /** @var \Symfony\Component\Finder\SplFileInfo $directory */
                foreach ($directories as $i => $directory): ?>
                    <div class="item dir" data-url="<?php echo $requestHelper->getParameter('directory').$directory->getFilename().'/'; ?>">
                        <div class="item-inner">
                            <div class="my-item-thumbnail">
                                <div class="my-item-thumbnail-inner">
                                    <i class="icon-folder"></i>
                                </div>
                            </div>
                            <div class="item-name">
                                <div class="item-name-inner">
                                    <div class="icon">
                                        <i class="icon-folder"></i>
                                    </div>
                                    <div class="name">
                                        <span title="<?php echo $directory->getFilename(); ?>"><?php echo $directory->getFilename(); ?></span>
                                    </div>
                                </div>
                            </div>
                            <?php if ($mediaHelper->isNonReadonlyDirectory($requestHelper->getParameter('directory'), $directory->getFilename()) && $view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
                                <div class="item-menu">
                                <span class="file-manager-dropdown-btn" data-toggle="dropdown-<?php echo $i; ?>">
                                    <i class="icon-ellipsis-vert"></i>
                                </span>
                                    <div class="dropdown-pane item-dropdown" data-position="bottom" data-alignment="right" id="dropdown-<?php echo $i; ?>" data-dropdown data-close-on-click="true">
                                        <ul class="no-bullet">
                                            <li><a data-open="rename-form" data-old-name="<?php echo $directory->getFilename(); ?>"><i class="icon-edit"></i> <?php echo $translator->trans('media.dir.rename.title', [], 'media'); ?></a></li>
                                            <li><a data-open="delete-form" data-name="<?php echo $directory->getFilename(); ?>"><i class="icon-cancel-circled2"></i> <?php echo $translator->trans('media.dir.delete.title', [], 'media'); ?></a></li>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <?php if (! empty($files)): ?>
            <h6><?php echo $translator->trans('media.items.files', [], 'media'); ?></h6>
            <div class="items">
                <?php
                /** @var \Symfony\Component\HttpFoundation\File\File $file */
                foreach ($files as $i => $file): ?>
                    <?php $dimensions = $mediaHelper->isImage($file->getExtension()) ? getimagesize($file) : [null, null]; ?>
                    <div class="item"
                         data-info
                         data-filename="<?php echo $file->getFilename(); ?>"
                         data-link="<?php echo $file->link; ?>"
                         data-size="<?php echo $view['front']->formatBytes($file->getSize()); ?>"
                         data-dimension-width="<?php echo $dimensions[0]; ?>"
                         data-dimension-height="<?php echo $dimensions[1]; ?>"
                         data-is-image="<?php echo $mediaHelper->isImage($file->getExtension()) ? 'true' : 'false'; ?>"
                         data-icon="<?php echo $mediaHelper->getIcon($file->getExtension()); ?>"
                         data-extension="<?php echo $file->getExtension(); ?>"
                    >
                        <div class="item-inner">
                            <div class="my-item-thumbnail">
                                <div class="my-item-thumbnail-inner">
                                    <?php if ($mediaHelper->isImage($file->getExtension())): ?>
                                        <img src="<?php echo $file->link; ?>?thumb=200x200">
                                    <?php else: ?>
                                        <i class="<?php echo $mediaHelper->getIcon($file->getExtension()); ?>"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="my-item-thumbnail-hover">
                                    <span class="button tiny insert-file-hover"><?php echo $translator->trans('mediaList.insert'); ?></span>
                                </div>
                            </div>
                            <div class="item-name">
                                <div class="item-name-inner">
                                    <div class="icon">
                                        <i class="<?php echo $mediaHelper->getIcon($file->getExtension()); ?>"></i>
                                    </div>
                                    <div class="name">
                                        <span title="<?php echo $file->getFilename(); ?>"><?php echo $file->getFilename(); ?></span>
                                    </div>
                                    <div class="item-menu">
                                    <span class="file-manager-dropdown-btn" data-toggle="dropdown-file-<?php echo $i; ?>">
                                        <i class="icon-ellipsis-vert"></i>
                                    </span>
                                        <div class="dropdown-pane item-dropdown" data-position="bottom" data-alignment="right" id="dropdown-file-<?php echo $i; ?>" data-dropdown data-close-on-click="true">
                                            <ul class="no-bullet">
                                                <?php if ($mediaHelper->isNonReadonlyFile($requestHelper->getParameter('directory')) && $view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
                                                    <li><a data-open="rename-form" data-old-name="<?php echo $file->getFilename(); ?>"><i class="icon-edit"></i> <?php echo $translator->trans('media.file.rename.title', [], 'media'); ?></a></li>
                                                    <li><a data-open="delete-form" data-name="<?php echo $file->getFilename(); ?>"><i class="icon-cancel-circled2"></i> <?php echo $translator->trans('media.file.delete.title', [], 'media'); ?></a></li>
                                                <?php endif; ?>
                                                <li><a href="<?php echo $file->link; ?>" download="<?php $file->getFilename(); ?>"><i class="icon-download"></i> <?php echo $translator->trans('media.file.download.title', [], 'media'); ?></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="gallery-info-wrapper hide" id="gallery-info">
        <div class="gallery-info-inner-wrapper">
            <div class="gallery-info-header">
                <div class="icon" id="media-info-icon"><i class="icon-folder"></i></div>
                <div class="name" id="media-info-name"></div>
            </div>
            <div class="gallery-info-tab-content">
                <div class="img">
                    <div class="icon" id="media-info-image">
                        <i class="icon-folder"></i>
                    </div>
                </div>
                <div class="text-center">
                    <span class="button tiny secondary hollow" id="insert-button">
                        <i class="icon-upload"></i> <?php echo $translator->trans('media.insert'); ?>
                    </span>
                </div>
                <div class="details">
                    <p id="media-info-size"><strong><?php echo $translator->trans('media.info.size', [], 'media'); ?>:</strong> <span></span></p>
                    <p id="media-info-type"><strong><?php echo $translator->trans('media.info.type', [], 'media'); ?>:</strong> <span></span></p>
                    <p id="media-info-dimensions"><strong><?php echo $translator->trans('media.info.dimensions', [], 'media'); ?>:</strong> <span></span></p>

                    <div class="input-group clipboard gallery-picture-clipboard">
                        <span class="infoCopyUrl" style="opacity: 0; z-index: -1;"><span><?php echo $view['translator']->trans('galleries.details.copied'); ?></span></span>
                        <input type="text" id="media-info-url" class="input-group-field gallery_url" readonly value="">
                        <div class="input-group-button">
                            <button type="button" id="copy-to-clipboard" class="copy-to-clipboard button" data-tooltip title="<?php echo $view['translator']->trans('galleries.details.copy_to_clipboard'); ?>"><i class="icon-clipboard-2"></i></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
    <div class="reveal tiny" id="addFolder" data-reveal data-multiple-opened="true">
        <div class="row">
            <div class="columns">
                <h3><?php echo $translator->trans('media.dir.form.directory_name', [], 'media'); ?></h3>
                <form name="" method="post" id="nameNewFolderSend" data-directory="<?php echo $requestHelper->getParameter('directory'); ?>">
                    <input type="text" id="nameNewFolder" name="name" required="required" maxlength="100" placeholder="<?php echo $translator->trans('mediaList.nameFolder'); ?>">
                    <div class="float-right">
                        <button type="button" class="button no-margin tiny clear" data-close><?php echo $translator->trans('media.dir.form.cancel', [], 'media'); ?></button>
                        <button type="submit" class="button no-margin tiny"><?php echo $translator->trans('media.dir.form.create', [], 'media'); ?></button>
                    </div>
                </form>
            </div>
        </div>
        <button class="close-button" data-close aria-label="Close modal" type="button"><span aria-hidden="true">&times;</span></button>
    </div>
    <div class="reveal tiny" id="rename-form" data-reveal data-multiple-opened="true">
        <div class="row">
            <div class="columns">
                <h3><?php echo $translator->trans('media.form.rename', [], 'media'); ?></h3>
                <form name="rename" method="post" id="renameForm">
                    <input type="text" id="rename_name" name="rename[name]" required="required" maxlength="100" placeholder="<?php echo $translator->trans('media.form.name.title', [], 'media'); ?>">
                    <div class="float-right">
                        <button type="button" class="button no-margin tiny clear" data-close><?php echo $translator->trans('media.dir.form.cancel', [], 'media'); ?></button>
                        <button type="submit" class="button no-margin tiny"><?php echo $translator->trans('media.form.save', [], 'media'); ?></button>
                    </div>
                    <input type="hidden" id="rename_oldName" name="rename[oldName]" value="">
                </form>
            </div>
        </div>
        <button class="close-button" data-close aria-label="Close modal" type="button"><span aria-hidden="true">&times;</span></button>
    </div>
    <div class="reveal tiny" id="delete-form" data-reveal data-multiple-opened="true">
        <div class="row">
            <div class="columns">
                <h3><?php echo $translator->trans('media.form.delete_confirm', [], 'media'); ?></h3>
                <form name="delete" method="post" id="deleteForm">
                    <div class="float-left">
                        <div class="switch tiny">
                            <div class="switch-admin">
                                <input type="checkbox" id="delete_deleteConfirm" name="delete[deleteConfirm]" required="required" class="switch-input" value="1">
                                <label for="delete_deleteConfirm" class="switch-paddle">
                                    <span class="show-for-sr"></span>
                                    <span class="switch-active" aria-hidden="true"><?php echo $translator->trans('yes'); ?></span>
                                    <span class="switch-inactive" aria-hidden="true"><?php echo $translator->trans('no'); ?></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="float-right">
                        <button type="button" class="button no-margin tiny clear" data-close><?php echo $translator->trans('media.dir.form.cancel', [], 'media'); ?></button>
                        <button type="submit" class="button no-margin alert tiny"><?php echo $translator->trans('media.form.delete', [], 'media'); ?></button>
                    </div>
                    <input type="hidden" id="delete_delete" name="delete[delete]" value="">
                </form>
            </div>
        </div>
        <button class="close-button" data-close aria-label="Close modal" type="button"><span aria-hidden="true">&times;</span></button>
    </div>

    <?php /* Upload progress */ ?>
    <div class="tiny reveal upload-progress-wrapper" id="upload-progress-wrapper" data-reveal data-close-on-click="false" data-close-on-esc="false" data-multiple-opened="true">
        <div class="upload-loader-wrapper">
            <div class="lds-roller"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
        </div>
        <h3><?php echo $translator->trans('media.files.upload.upload_files', [], 'media'); ?> <span id="current-number"></span> <?php echo $translator->trans('media.files.upload.of', [], 'media'); ?> <span id="total-number"></span></h3>
        <div class="upload-progress">
            <div id="upload-progress" class="progress" role="progressbar" tabindex="0" aria-valuemin="0" aria-valuemax="100">
            <span class="progress-meter" style="width: 0%">
                <p class="progress-meter-text">0%</p>
            </span>
            </div>
        </div>
        <div class="callout primary"><?php echo $translator->trans('media.files.upload.info', [], 'media'); ?></div>
    </div>
<?php endif; ?>
