<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>


<?php $view['slots']->set('title', $view['translator']->trans('title.log.logShow')) ?>


<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_logs_show', ['id' => $log->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.log.logShow'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('log.listTitle'); ?> - <?php echo $view['translator']->trans('log.subTitleShow'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-mail"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('log.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <h3 class="box-title">
                <span><?php echo $view['translator']->trans('show.details'); ?> - <?php echo $log->getId(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('log.dateMessage'); ?>:</strong><br>
                        <strong><?php echo $view['translator']->trans('log.recipient'); ?>:</strong><br>
                        <strong><?php echo $view['translator']->trans('log.sender'); ?>:</strong><br>
                        <strong><?php echo $view['translator']->trans('log.campaign'); ?>:</strong><br>
                        <strong><?php echo $view['translator']->trans('log.message'); ?>:</strong><br>
                        <hr>
                        <strong><?php echo $view['translator']->trans('log.messageContent'); ?>:</strong>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="showShortDesc">
                        <p><?php if ($log->getDateMessage()) {echo $log->getDateMessage()->format('Y-m-d');} ?><br>
                            <?php echo ($recipient = $log->getRecipient()) ? $recipient->getEmail() : null; ?><br>
                            <?php echo ($sender = $log->getSender()) ? $sender->getEmail() : null; ?><br>
                            <?php echo ($campaign = $log->getCampaign()) ? $campaign->getName() : null; ?><br>
                            <?php if ($log->getMessageContent()) {echo $log->getMessageContent()->getTitle();} ?><br>
                            <hr>
                            <div class="callout">
                                <?php if ($log->getMessageContent()) {echo $log->getMessageContent()->getMessage();;} ?>
                            </div>
                        </p>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('log.note'); ?>:</strong></p>
                </div>
                <div class="large-10 columns">
                    <div class="callout">
                        <p><?php echo $log->getNote(); ?></p>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
