<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_block_itemHTML_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.item.Show')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/block.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li><?php echo $view['translator']->trans('main-menu.template_extension'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.item'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_show', ['id' => $itemHTML->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.Show'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('item.listTitle'); ?> - <?php echo $view['translator']->trans('itemShow.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-th-large-2"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('itemShow.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowPages-dropdown">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowPages-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_edit', array('id' => $itemHTML->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_delete', ['id' => $itemHTML->getId()]); ?>">
                                    <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('itemShow.deleteButton'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
             <h3 class="box-title"><i class="icon-doc-text-1"></i>
                <span><?php echo $view['translator']->trans('catShow.listSubTitle'); ?> - <?php echo $itemHTML->getName(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
             <div class="row">
                <div class="large-10 columns">
                    <p><strong><?php echo $view['translator']->trans('itemNew.form.nameTitle'); ?>:</strong>
                        <?php echo $itemHTML->getName(); ?>
                    </p>
                    <p><strong><?php echo $view['translator']->trans('itemNew.form.dateStart'); ?>:</strong>
                        <?php if ($itemHTML->getDateStart()): ?>
                            <?php echo $itemHTML->getDateEnd()->format('Y-m-d H:i:s'); ?>
                        <?php endif; ?>
                    </p>
                    <p><strong><?php echo $view['translator']->trans('itemNew.form.dateEnd'); ?>:</strong>
                        <?php if ($itemHTML->getDateEnd()): ?>
                            <?php echo $itemHTML->getDateEnd()->format('Y-m-d H:i:s'); ?>
                        <?php endif; ?>
                    </p>
                    <br>
                    <p><strong><?php echo $view['translator']->trans('itemNew.form.itemGroup'); ?>:</strong>
                        <a href="<?php echo $view['router']->path('wi_admin_block_show', ['id' => $itemHTML->getBlock()->getId()]); ?>"><span class="info button showPagesButton"><?php echo $itemHTML->getBlock()->getName(); ?></span></a>
                    </p>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('itemNew.form.textTitle'); ?>:</strong></p>
                </div>
                <div class="large-10 columns">
                    <div class="showTinyPreview">
                        <textarea class="tinymceShowContent">
                            <?php echo $itemHTML->getContent(); ?>
                        </textarea>
                    </div>
                    <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_edit', array('id' => $itemHTML->getId())); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                            <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/block.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
