<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_galleries_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.galleries.gallery.edit')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/galleries.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.content'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_galleries_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.galleries.gallery.index'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_galleries_edit', ['id' => $gallery->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.galleries.gallery.edit'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite') ?>
<?php echo $view['translator']->trans('galleries.gallery.index.title'); ?> - <?php echo $view['translator']->trans('galleries.gallery.edit.title'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-camera-1 color-menu-content"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
<?php echo $view['translator']->trans('galleries.gallery.edit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>


<?php echo $view['form']->start($form) ?>
<?php $cropperDimensions = [
    'width' => $view['config']->get('gallery.coverWidth'),
    'height' => $view['config']->get('gallery.coverHeight'),
]; ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <h3 class="box-title"><i class="icon-picture"></i><span><?php echo $view['translator']->trans('galleries.gallery.edit.subtitle'); ?></span></h3>
        </div>
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="columns large-2">
                    <p><strong><?php echo $view['translator']->trans('galleries.gallery.form.title.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('galleries.gallery.form.title.desc'); ?>"></i>
                    </p>
                </div>
                <div class="columns large-10">
                    <div class="medium-6">
                        <div class="formAlert"><?php echo $view['form']->errors($form['title']); ?></div>
                        <?php echo $view['form']->widget($form['title'], [
                            'attr' => [
                                'class' => ($form['title']->vars['attr']['class'] ?? '') . (! $form['title']->vars['valid'] ? ' callout alert' : null),
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="columns large-2">
                    <p><strong><?php echo $view['translator']->trans('galleries.gallery.form.cover.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('galleries.gallery.form.cover.desc'); ?>"></i>
                    </p>
                </div>
                <div class="columns large-10">
                    <div class="large reveal" id="windowModalCropper" data-reveal data-close-on-click="false">
                        <div class="containerCropper">
                            <img id="cropperImage" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg') ?>"
                                data-file-id="<?php echo $form->children['file']->vars['id']; ?>"
                                data-crop-x-id="<?php echo $form->children['crop_x']->vars['id']; ?>"
                                data-crop-y-id="<?php echo $form->children['crop_y']->vars['id']; ?>"
                                data-crop-height-id="<?php echo $form->children['crop_height']->vars['id']; ?>"
                                data-crop-width-id="<?php echo $form->children['crop_width']->vars['id']; ?>"
                                data-crop-save-id="<?php echo $form->children['cropSave']->vars['id']; ?>"
                                alt="">
                        </div>
                        <div class="row buttonAddImage">
                            <div class="medium-12 columns">
                                <button type="button" class="button" id="Wyslijfoto" data-close aria-label="Close modal"><i class="icon-ok"></i> <?php echo $view['translator']->trans('newsNew.form.saveImage'); ?></button>
                                <button type="button" class="button secondary float-right"  data-close aria-label="Close modal"><i class="icon-cancel"></i> <?php echo $view['translator']->trans('Form.backShow'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo $view['form']->widget($form['crop_x']); ?>
                    <?php echo $view['form']->widget($form['crop_y']); ?>
                    <?php echo $view['form']->widget($form['crop_height']); ?>
                    <?php echo $view['form']->widget($form['crop_width']); ?>
                    <?php echo $view['form']->widget($form['cropSave']); ?>

                    <?php $cover = $gallery->getCover() ? $gallery->getCoverUrl() : 'media/Admin/WiCMS3/img/noimage.jpg'; ?>
                    <img id="cropperPreview" class="previewImage thumbnail"  src="<?php echo $view['assets']->getUrl($cover) ?>" alt="" data-open="windowModalCropper">
                    <label class="AddImage" for="<?php echo $form->children['file']->vars['id']; ?>">
                        <?php echo $view['form']->widget($form['file']); ?>
                        <span class="button" id="imageDataFromParameter" type="button" cropper-width="<?php echo $cropperDimensions['width']; ?>" cropper-height="<?php echo $cropperDimensions['height']; ?>">
                            <i class="icon-upload"></i><?php echo $view['translator']->trans('newsEdit.form.addImage'); ?>
                        </span>
                    </label>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="columns large-2">
                    <p><strong><?php echo $view['translator']->trans('galleries.gallery.form.content.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('galleries.gallery.form.content.desc'); ?>"></i>
                    </p>
                </div>
                <div class="columns large-10">
                    <div class="formAlert"><?php echo $view['form']->errors($form['content']); ?></div>
                    <?php echo $view['form']->widget($form['content'], [
                        'attr' => [
                            'class' => ($form['content']->vars['attr']['class'] ?? '') . (! $form['content']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="columns large-2">
                    <p><strong><?php echo $view['translator']->trans('galleries.gallery.form.parent.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('galleries.gallery.form.parent.desc'); ?>"></i>
                    </p>
                </div>
                <div class="columns large-10">
                    <div class="formAlert"><?php echo $view['form']->errors($form['parent']); ?></div>
                    <?php echo $view['form']->widget($form['parent'], [
                        'attr' => [
                            'class' => ($form['parent']->vars['attr']['class'] ?? '') . (! $form['parent']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="columns large-2">
                    <p><strong><?php echo $view['translator']->trans('galleries.gallery.form.visible.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('galleries.gallery.form.visible.desc'); ?>"></i>
                    </p>
                </div>
                <div class="columns large-10">
                    <?php echo $view['form']->errors($form['visible']); ?>
                    <?php echo $view['form']->widget($form['visible']); ?>
                </div>
            </div>
        </div>
    </div>

<div class="box metaTags collapsed-box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools"><span><i class="icon-up-open" data-widget="collapse"></i></span></div>
        <h3 class="box-title" data-widget="collapse">
            <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('metadata.block.header'); ?></span>
        </h3>
    </div>
    <div class="box-body " style="display: none;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('metadata.meta.title'); ?></strong><i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('metadata.meta.desc'); ?>"></i></p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="news-add-form">
                            <?php echo $view['form']->label($form['metaTitle']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['metaTitle']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['metaTitle']) ? $view['form']->widget($form['metaTitle'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaTitle'])); ?>
                        </div>
                        <div class="news-add-form">
                            <?php echo $view['form']->label($form['metaDescription']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['metaDescription']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['metaDescription']) ? $view['form']->widget($form['metaDescription'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaDescription'])); ?>
                        </div>
                        <div class="news-add-form">
                            <?php echo $view['form']->label($form['metaKeywords']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['metaKeywords']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['metaKeywords']) ? $view['form']->widget($form['metaKeywords'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaKeywords'])); ?>
                        </div>
                        <div class="news-add-form">
                            <?php echo $view['form']->label($form['metaCanonical']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['metaCanonical']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['metaCanonical']) ? $view['form']->widget($form['metaCanonical'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaCanonical'])); ?>
                        </div>
                        <div class="news-add-form">
                            <?php echo $view['form']->label($form['metaImage']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['metaImage']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['metaImage']) ? $view['form']->widget($form['metaImage'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaImage'])); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="columns">
        <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
            <i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.send'); ?>
        </button>
        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_galleries_index', ['id' => $gallery->getId()]); ?>">
            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
        </a>
    </div>
</div>
<?php echo $view['form']->end($form) ?>

<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>"></script>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/galleries.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
